/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.ExecuteTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.exception.FlowSystemException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.executor.NodeExecutor;
import com.yomahub.liteflow.flow.executor.NodeExecutorHelper;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node
implements Executable,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(Node.class);
    private String id;
    private String name;
    private String clazz;
    private NodeTypeEnum type;
    private String script;
    private NodeComponent instance;
    private String tag;
    private String cmpData;
    private String currChainId;
    private TransmittableThreadLocal<Integer> loopIndexTL = new TransmittableThreadLocal();
    private TransmittableThreadLocal<Object> currLoopObject = new TransmittableThreadLocal();

    public Node() {
    }

    public Node(NodeComponent instance) {
        this.id = instance.getNodeId();
        this.name = instance.getName();
        this.instance = instance;
        this.type = instance.getType();
        this.clazz = instance.getClass().getName();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NodeTypeEnum getType() {
        return this.type;
    }

    public void setType(NodeTypeEnum type) {
        this.type = type;
    }

    public NodeComponent getInstance() {
        return this.instance;
    }

    public void setInstance(NodeComponent instance) {
        this.instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Integer slotIndex) throws Exception {
        block13: {
            if (ObjectUtil.isNull((Object)this.instance)) {
                throw new FlowSystemException("there is no instance for node id " + this.id);
            }
            Slot slot = DataBus.getSlot(slotIndex);
            try {
                this.instance.setSlotIndex(slotIndex);
                this.instance.setRefNode(this);
                LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
                if (this.instance.isAccess()) {
                    if (BooleanUtil.isTrue((Boolean)liteflowConfig.getPrintExecutionLog())) {
                        LOG.info("[{}]:[O]start component[{}] execution", (Object)slot.getRequestId(), (Object)this.instance.getDisplayName());
                    }
                    NodeExecutor nodeExecutor = NodeExecutorHelper.loadInstance().buildNodeExecutor(this.instance.getNodeExecutorClass());
                    nodeExecutor.execute(this.instance);
                    if (this.instance.isEnd()) {
                        String errorInfo = StrUtil.format((CharSequence)"[{}]:[{}] lead the chain to end", (Object[])new Object[]{slot.getRequestId(), this.instance.getDisplayName()});
                        throw new ChainEndException(errorInfo);
                    }
                } else if (BooleanUtil.isTrue((Boolean)liteflowConfig.getPrintExecutionLog())) {
                    LOG.info("[{}]:[X]skip component[{}] execution", (Object)slot.getRequestId(), (Object)this.instance.getDisplayName());
                }
            }
            catch (ChainEndException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.instance.isContinueOnError()) {
                    String errorMsg = MessageFormat.format("[{0}]:component[{1}] cause error,but flow is still go on", slot.getRequestId(), this.id);
                    LOG.error(errorMsg);
                    break block13;
                }
                String errorMsg = MessageFormat.format("[{0}]:component[{1}] cause error,error:{2}", slot.getRequestId(), this.id, e.getMessage());
                LOG.error(errorMsg);
                throw e;
            }
            finally {
                this.instance.removeSlotIndex();
                this.instance.removeIsEnd();
                this.instance.removeRefNode();
                this.removeLoopIndex();
            }
        }
    }

    @Override
    public boolean isAccess(Integer slotIndex) throws Exception {
        this.instance.setSlotIndex(slotIndex);
        this.instance.setRefNode(this);
        return this.instance.isAccess();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Node copy() throws Exception {
        return (Node)this.clone();
    }

    @Override
    public ExecuteTypeEnum getExecuteType() {
        return ExecuteTypeEnum.NODE;
    }

    @Override
    public String getExecuteId() {
        return this.id;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getCmpData() {
        return this.cmpData;
    }

    public void setCmpData(String cmpData) {
        this.cmpData = cmpData;
    }

    @Override
    public void setCurrChainId(String currentChainId) {
        this.currChainId = currentChainId;
    }

    public String getCurrChainId() {
        return this.currChainId;
    }

    public void setLoopIndex(int index) {
        this.loopIndexTL.set((Object)index);
    }

    public Integer getLoopIndex() {
        return (Integer)this.loopIndexTL.get();
    }

    public void removeLoopIndex() {
        this.loopIndexTL.remove();
    }

    public void setCurrLoopObject(Object obj) {
        this.currLoopObject.set(obj);
    }

    public <T> T getCurrLoopObject() {
        return (T)this.currLoopObject.get();
    }

    public void removeCurrLoopObject() {
        this.currLoopObject.remove();
    }
}

