/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import cn.hutool.core.date.StopWatch;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.yomahub.liteflow.core.FlowExecutorHolder;
import com.yomahub.liteflow.enums.CmpStepTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.LiteflowResponse;
import com.yomahub.liteflow.flow.entity.CmpStep;
import com.yomahub.liteflow.flow.executor.DefaultNodeExecutor;
import com.yomahub.liteflow.flow.executor.NodeExecutor;
import com.yomahub.liteflow.monitor.CompStatistics;
import com.yomahub.liteflow.monitor.MonitorBus;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.spi.holder.CmpAroundAspectHolder;
import com.yomahub.liteflow.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeComponent {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private MonitorBus monitorBus;
    private String nodeId;
    private String name;
    private NodeTypeEnum type;
    private NodeComponent self;
    private int retryCount = 0;
    private Class<? extends Exception>[] retryForExceptions = new Class[]{Exception.class};
    private Class<? extends NodeExecutor> nodeExecutorClass = DefaultNodeExecutor.class;
    private final TransmittableThreadLocal<Integer> slotIndexTL = new TransmittableThreadLocal();
    private final TransmittableThreadLocal<Boolean> isEndTL = new TransmittableThreadLocal();
    private final TransmittableThreadLocal<String> tagTL = new TransmittableThreadLocal();
    private final TransmittableThreadLocal<String> currChainNameTL = new TransmittableThreadLocal();
    private final TransmittableThreadLocal<String> cmpDataTL = new TransmittableThreadLocal();

    public void execute() throws Exception {
        Slot slot = this.getSlot();
        CmpStep cmpStep = new CmpStep(this.nodeId, this.name, CmpStepTypeEnum.SINGLE);
        cmpStep.setTag((String)this.tagTL.get());
        slot.addStep(cmpStep);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.self.beforeProcess(this.getNodeId(), slot);
            this.self.process();
            this.self.onSuccess();
            cmpStep.setSuccess(true);
            this.self.afterProcess(this.getNodeId(), slot);
        }
        catch (Exception e) {
            try {
                cmpStep.setSuccess(false);
                cmpStep.setException(e);
                try {
                    this.self.onError();
                }
                catch (Exception ex) {
                    String errMsg = StrUtil.format((CharSequence)"[{}]:component[{}] onError method happens exception", (Object[])new Object[]{slot.getRequestId(), this.getDisplayName()});
                    this.LOG.error(errMsg);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.self.afterProcess(this.getNodeId(), slot);
                stopWatch.stop();
                long timeSpent = stopWatch.getTotalTimeMillis();
                this.LOG.debug("[{}]:component[{}] finished in {} milliseconds", new Object[]{slot.getRequestId(), this.getDisplayName(), timeSpent});
                cmpStep.setTimeSpent(timeSpent);
                if (ObjectUtil.isNotNull((Object)this.monitorBus)) {
                    CompStatistics statistics = new CompStatistics(this.getClass().getSimpleName(), timeSpent);
                    this.monitorBus.addStatistics(statistics);
                }
                throw throwable;
            }
        }
        stopWatch.stop();
        long timeSpent = stopWatch.getTotalTimeMillis();
        this.LOG.debug("[{}]:component[{}] finished in {} milliseconds", new Object[]{slot.getRequestId(), this.getDisplayName(), timeSpent});
        cmpStep.setTimeSpent(timeSpent);
        if (ObjectUtil.isNotNull((Object)this.monitorBus)) {
            CompStatistics statistics = new CompStatistics(this.getClass().getSimpleName(), timeSpent);
            this.monitorBus.addStatistics(statistics);
        }
    }

    public <T> void beforeProcess(String nodeId, Slot slot) {
        CmpAroundAspectHolder.loadCmpAroundAspect().beforeProcess(nodeId, slot);
    }

    public abstract void process() throws Exception;

    public void onSuccess() throws Exception {
    }

    public void onError() throws Exception {
    }

    public <T> void afterProcess(String nodeId, Slot slot) {
        CmpAroundAspectHolder.loadCmpAroundAspect().afterProcess(nodeId, slot);
    }

    public boolean isAccess() {
        return true;
    }

    public boolean isContinueOnError() {
        return false;
    }

    public boolean isEnd() {
        Boolean isEnd = (Boolean)this.isEndTL.get();
        if (ObjectUtil.isNull((Object)isEnd)) {
            return false;
        }
        return (Boolean)this.isEndTL.get();
    }

    public void setIsEnd(boolean isEnd) {
        this.isEndTL.set((Object)isEnd);
    }

    public void removeIsEnd() {
        this.isEndTL.remove();
    }

    public NodeComponent setSlotIndex(Integer slotIndex) {
        this.slotIndexTL.set((Object)slotIndex);
        return this;
    }

    public Integer getSlotIndex() {
        return (Integer)this.slotIndexTL.get();
    }

    public void removeSlotIndex() {
        this.slotIndexTL.remove();
    }

    public Slot getSlot() {
        return DataBus.getSlot((Integer)this.slotIndexTL.get());
    }

    public <T> T getFirstContextBean() {
        return this.getSlot().getFirstContextBean();
    }

    public <T> T getContextBean(Class<T> contextBeanClazz) {
        return this.getSlot().getContextBean(contextBeanClazz);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public NodeComponent getSelf() {
        return this.self;
    }

    public void setSelf(NodeComponent self) {
        this.self = self;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NodeTypeEnum getType() {
        return this.type;
    }

    public void setType(NodeTypeEnum type) {
        this.type = type;
    }

    public <T> void sendPrivateDeliveryData(String nodeId, T t) {
        this.getSlot().setPrivateDeliveryData(nodeId, t);
    }

    public <T> T getPrivateDeliveryData() {
        return this.getSlot().getPrivateDeliveryData(this.getNodeId());
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public Class<? extends Exception>[] getRetryForExceptions() {
        return this.retryForExceptions;
    }

    public void setRetryForExceptions(Class<? extends Exception>[] retryForExceptions) {
        this.retryForExceptions = retryForExceptions;
    }

    public Class<? extends NodeExecutor> getNodeExecutorClass() {
        return this.nodeExecutorClass;
    }

    public void setNodeExecutorClass(Class<? extends NodeExecutor> nodeExecutorClass) {
        this.nodeExecutorClass = nodeExecutorClass;
    }

    public void setTag(String tag) {
        this.tagTL.set((Object)tag);
    }

    public String getTag() {
        return (String)this.tagTL.get();
    }

    public void removeTag() {
        this.tagTL.remove();
    }

    public MonitorBus getMonitorBus() {
        return this.monitorBus;
    }

    public void setMonitorBus(MonitorBus monitorBus) {
        this.monitorBus = monitorBus;
    }

    public <T> T getRequestData() {
        return this.getSlot().getRequestData();
    }

    public <T> T getSubChainReqData() {
        return this.getSlot().getChainReqData(this.getCurrChainName());
    }

    public <T> T getSubChainReqDataInAsync() {
        return this.getSlot().getChainReqDataFromQueue(this.getCurrChainName());
    }

    @Deprecated
    public String getChainName() {
        return this.getSlot().getChainName();
    }

    public String getChainId() {
        return this.getSlot().getChainId();
    }

    public String getDisplayName() {
        if (StrUtil.isEmpty((CharSequence)this.name)) {
            return this.nodeId;
        }
        return StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{this.nodeId, this.name});
    }

    @Deprecated
    public void setCurrChainName(String currChainName) {
        this.currChainNameTL.set((Object)currChainName);
    }

    @Deprecated
    public String getCurrChainName() {
        return (String)this.currChainNameTL.get();
    }

    @Deprecated
    public void removeCurrChainName() {
        this.currChainNameTL.remove();
    }

    public void setCurrChainId(String currChainName) {
        this.currChainNameTL.set((Object)currChainName);
    }

    public String getCurrChainId() {
        return (String)this.currChainNameTL.get();
    }

    public void removeCurrChainId() {
        this.currChainNameTL.remove();
    }

    public void setCmpData(String cmpData) {
        this.cmpDataTL.set((Object)cmpData);
    }

    public <T> T getCmpData(Class<T> clazz) {
        if (StrUtil.isBlank((CharSequence)((CharSequence)this.cmpDataTL.get()))) {
            return null;
        }
        if (clazz.equals(String.class)) {
            return (T)this.cmpDataTL.get();
        }
        return JsonUtil.parseObject((String)this.cmpDataTL.get(), clazz);
    }

    public void removeCmpData() {
        this.cmpDataTL.remove();
    }

    public void invoke(String chainId, Object param) throws Exception {
        FlowExecutorHolder.loadInstance().invoke(chainId, param, this.getSlotIndex());
    }

    public LiteflowResponse invoke2Resp(String chainId, Object param) {
        return FlowExecutorHolder.loadInstance().invoke2Resp(chainId, param, this.getSlotIndex());
    }

    public void invokeInAsync(String chainId, Object param) throws Exception {
        FlowExecutorHolder.loadInstance().invokeInAsync(chainId, param, this.getSlotIndex());
    }

    public LiteflowResponse invoke2RespInAsync(String chainId, Object param) {
        return FlowExecutorHolder.loadInstance().invoke2RespInAsync(chainId, param, this.getSlotIndex());
    }
}

