/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script.proxy;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.proxy.LiteFlowProxyUtil;
import com.yomahub.liteflow.exception.ProxyException;
import com.yomahub.liteflow.exception.ScriptBeanMethodInvokeException;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.script.annotation.ScriptBean;
import com.yomahub.liteflow.util.SerialsUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ScriptBeanProxy {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());
    private final Object bean;
    private final Class<?> orignalClass;
    private final ScriptBean scriptBeanAnno;

    public ScriptBeanProxy(Object bean, Class<?> orignalClass, ScriptBean scriptBeanAnno) {
        this.bean = bean;
        this.orignalClass = orignalClass;
        this.scriptBeanAnno = scriptBeanAnno;
    }

    public Object getProxyScriptBean() {
        List<String> methodNameList = Arrays.stream(this.orignalClass.getMethods()).map(Method::getName).collect(Collectors.toList());
        if (ArrayUtil.isNotEmpty((Object[])this.scriptBeanAnno.includeMethodName())) {
            methodNameList = methodNameList.stream().filter(methodName -> ListUtil.toList((Object[])this.scriptBeanAnno.includeMethodName()).contains(methodName)).collect(Collectors.toList());
        }
        if (ArrayUtil.isNotEmpty((Object[])this.scriptBeanAnno.excludeMethodName())) {
            methodNameList = methodNameList.stream().filter(methodName -> !ListUtil.toList((Object[])this.scriptBeanAnno.excludeMethodName()).contains(methodName)).collect(Collectors.toList());
        }
        try {
            Class c = new ByteBuddy().subclass(this.orignalClass).name(StrUtil.format((CharSequence)"{}.ByteBuddy${}", (Object[])new Object[]{ClassUtil.getPackage(this.orignalClass), SerialsUtil.generateShortUUID()})).implement((Type[])this.bean.getClass().getInterfaces()).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new AopInvocationHandler(this.bean, methodNameList))).annotateType(this.orignalClass.getAnnotations()).make().load(ScriptBeanProxy.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
            return ReflectUtil.newInstanceIfPossible((Class)c);
        }
        catch (Exception e) {
            throw new ProxyException(e);
        }
    }

    public class AopInvocationHandler
    implements InvocationHandler {
        private final Object bean;
        private final Class<?> clazz;
        private final List<String> canExecuteMethodNameList;

        public AopInvocationHandler(Object bean, List<String> canExecuteMethodNameList) {
            this.bean = bean;
            this.clazz = LiteFlowProxyUtil.getUserClass(bean.getClass());
            this.canExecuteMethodNameList = canExecuteMethodNameList;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method invokeMethod = Arrays.stream(this.clazz.getMethods()).filter(m -> m.getName().equals(method.getName()) && m.getParameterCount() == method.getParameterCount()).findFirst().orElse(null);
            if (invokeMethod == null) {
                String errorMsg = StrUtil.format((CharSequence)"cannot find method[{}]", (Object[])new Object[]{this.clazz.getName(), method.getName()});
                throw new ScriptBeanMethodInvokeException(errorMsg);
            }
            if (!this.canExecuteMethodNameList.contains(method.getName())) {
                String errorMsg = StrUtil.format((CharSequence)"script bean method[{}.{}] cannot be executed", (Object[])new Object[]{this.clazz.getName(), method.getName()});
                throw new ScriptBeanMethodInvokeException(errorMsg);
            }
            return invokeMethod.invoke(this.bean, args);
        }
    }
}

