/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.slot;

import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.NoSuchContextBeanException;
import com.yomahub.liteflow.exception.NullParamException;
import com.yomahub.liteflow.flow.entity.CmpStep;
import com.yomahub.liteflow.flow.id.IdGeneratorHolder;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Slot {
    private static final LFLog LOG = LFLoggerManager.getLogger(Slot.class);
    private static final String REQUEST = "_request";
    private static final String RESPONSE = "_response";
    private static final String CHAIN_NAME = "_chain_name";
    private static final String SWITCH_NODE_PREFIX = "_switch_";
    private static final String IF_NODE_PREFIX = "_if_";
    private static final String AND_OR_PREFIX = "_and_or_";
    private static final String NOT_PREFIX = "_not_";
    private static final String FOR_PREFIX = "_for_";
    private static final String WHILE_PREFIX = "_while_";
    private static final String ITERATOR_PREFIX = "_iterator_";
    private static final String BREAK_PREFIX = "_break_";
    private static final String NODE_INPUT_PREFIX = "_input_";
    private static final String NODE_OUTPUT_PREFIX = "_output_";
    private static final String CHAIN_REQ_PREFIX = "_chain_req_";
    private static final String REQUEST_ID = "_req_id";
    private static final String EXCEPTION = "_exception";
    private static final String SUB_EXCEPTION_PREFIX = "_sub_exception_";
    private static final String PRIVATE_DELIVERY_PREFIX = "_private_d_";
    private static final String SUB_CHAIN = "_sub_chain";
    private final Deque<CmpStep> executeSteps = new ConcurrentLinkedDeque<CmpStep>();
    private String executeStepsStr;
    protected ConcurrentHashMap<String, Object> metaDataMap = new ConcurrentHashMap();
    private List<Object> contextBeanList;

    public Slot() {
    }

    public Slot(List<Object> contextBeanList) {
        this.contextBeanList = contextBeanList;
    }

    private boolean hasMetaData(String key) {
        return this.metaDataMap.containsKey(key);
    }

    private <T> void putThreadMetaDataMap(String key, T t) {
        String threadKey = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{key, Thread.currentThread().getName()});
        this.putMetaDataMap(threadKey, t);
    }

    private <T> T getThreadMetaData(String key) {
        String threadKey = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{key, Thread.currentThread().getName()});
        return (T)this.metaDataMap.get(threadKey);
    }

    private <T> void putMetaDataMap(String key, T t) {
        if (ObjectUtil.isNull(t)) {
            throw new NullParamException("data slot can't accept null param");
        }
        this.metaDataMap.put(key, t);
    }

    public <T> T getInput(String nodeId) {
        return (T)this.metaDataMap.get(NODE_INPUT_PREFIX + nodeId);
    }

    public <T> T getOutput(String nodeId) {
        return (T)this.metaDataMap.get(NODE_OUTPUT_PREFIX + nodeId);
    }

    public <T> void setInput(String nodeId, T t) {
        this.putMetaDataMap(NODE_INPUT_PREFIX + nodeId, t);
    }

    public <T> void setOutput(String nodeId, T t) {
        this.putMetaDataMap(NODE_OUTPUT_PREFIX + nodeId, t);
    }

    public <T> T getRequestData() {
        return (T)this.metaDataMap.get(REQUEST);
    }

    public <T> void setRequestData(T t) {
        this.putMetaDataMap(REQUEST, t);
    }

    public <T> T getResponseData() {
        return (T)this.metaDataMap.get(RESPONSE);
    }

    public <T> void setResponseData(T t) {
        this.putMetaDataMap(RESPONSE, t);
    }

    public <T> T getChainReqData(String chainId) {
        String key = CHAIN_REQ_PREFIX + chainId;
        if (this.hasMetaData(key)) {
            return (T)this.metaDataMap.get(key);
        }
        return null;
    }

    public synchronized <T> void setChainReqData(String chainId, T t) {
        String key = CHAIN_REQ_PREFIX + chainId;
        this.putMetaDataMap(key, t);
    }

    public <T> T getChainReqDataFromQueue(String chainId) {
        String key = CHAIN_REQ_PREFIX + chainId;
        if (this.hasMetaData(key)) {
            Queue queue = (Queue)this.metaDataMap.get(key);
            return (T)queue.poll();
        }
        return null;
    }

    public synchronized <T> void setChainReqData2Queue(String chainId, T t) {
        String key = CHAIN_REQ_PREFIX + chainId;
        if (this.hasMetaData(key)) {
            Queue queue = (Queue)this.metaDataMap.get(key);
            queue.offer(t);
        } else {
            this.putMetaDataMap(key, new ConcurrentLinkedQueue(ListUtil.toList((Object[])new Object[]{t})));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setPrivateDeliveryData(String nodeId, T t) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        Slot slot = this;
        synchronized (slot) {
            if (this.metaDataMap.containsKey(privateDKey)) {
                Queue queue = (Queue)this.metaDataMap.get(privateDKey);
                queue.add(t);
            } else {
                ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue<T>();
                queue.add(t);
                this.putMetaDataMap(privateDKey, queue);
            }
        }
    }

    public <T> Queue<T> getPrivateDeliveryQueue(String nodeId) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        if (this.metaDataMap.containsKey(privateDKey)) {
            return (Queue)this.metaDataMap.get(privateDKey);
        }
        return null;
    }

    public <T> T getPrivateDeliveryData(String nodeId) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        if (this.metaDataMap.containsKey(privateDKey)) {
            Queue queue = (Queue)this.metaDataMap.get(privateDKey);
            return (T)queue.poll();
        }
        return null;
    }

    public <T> void setSwitchResult(String key, T t) {
        this.putThreadMetaDataMap(SWITCH_NODE_PREFIX + key, t);
    }

    public <T> T getSwitchResult(String key) {
        return this.getThreadMetaData(SWITCH_NODE_PREFIX + key);
    }

    public void setIfResult(String key, boolean result) {
        this.putThreadMetaDataMap(IF_NODE_PREFIX + key, result);
    }

    public boolean getIfResult(String key) {
        return (Boolean)this.getThreadMetaData(IF_NODE_PREFIX + key);
    }

    public void setAndOrResult(String key, boolean result) {
        this.putThreadMetaDataMap(AND_OR_PREFIX + key, result);
    }

    public boolean getAndOrResult(String key) {
        return (Boolean)this.getThreadMetaData(AND_OR_PREFIX + key);
    }

    public void setNotResult(String key, boolean result) {
        this.putThreadMetaDataMap(NOT_PREFIX + key, result);
    }

    public boolean getNotResult(String key) {
        return (Boolean)this.getThreadMetaData(NOT_PREFIX + key);
    }

    public void setForResult(String key, int forCount) {
        this.putThreadMetaDataMap(FOR_PREFIX + key, forCount);
    }

    public int getForResult(String key) {
        return (Integer)this.getThreadMetaData(FOR_PREFIX + key);
    }

    public void setWhileResult(String key, boolean whileFlag) {
        this.putThreadMetaDataMap(WHILE_PREFIX + key, whileFlag);
    }

    public boolean getWhileResult(String key) {
        return (Boolean)this.getThreadMetaData(WHILE_PREFIX + key);
    }

    public void setBreakResult(String key, boolean breakFlag) {
        this.putThreadMetaDataMap(BREAK_PREFIX + key, breakFlag);
    }

    public boolean getBreakResult(String key) {
        return (Boolean)this.getThreadMetaData(BREAK_PREFIX + key);
    }

    public void setIteratorResult(String key, Iterator<?> it) {
        this.putThreadMetaDataMap(ITERATOR_PREFIX + key, it);
    }

    public Iterator<?> getIteratorResult(String key) {
        return (Iterator)this.getThreadMetaData(ITERATOR_PREFIX + key);
    }

    @Deprecated
    public void setChainName(String chainName) {
        this.setChainId(chainName);
    }

    @Deprecated
    public String getChainName() {
        return this.getChainId();
    }

    public void setChainId(String chainId) {
        if (!this.hasMetaData(CHAIN_NAME)) {
            this.putMetaDataMap(CHAIN_NAME, chainId);
        }
    }

    public String getChainId() {
        return (String)this.metaDataMap.get(CHAIN_NAME);
    }

    public void addStep(CmpStep step) {
        this.executeSteps.add(step);
    }

    public String getExecuteStepStr(boolean withTimeSpent) {
        StringBuilder str = new StringBuilder();
        Iterator<CmpStep> it = this.executeSteps.iterator();
        while (it.hasNext()) {
            CmpStep cmpStep = it.next();
            if (withTimeSpent) {
                str.append(cmpStep.buildStringWithTime());
            } else {
                str.append(cmpStep.buildString());
            }
            if (!it.hasNext()) continue;
            str.append("==>");
        }
        this.executeStepsStr = str.toString();
        return this.executeStepsStr;
    }

    public String getExecuteStepStr() {
        return this.getExecuteStepStr(false);
    }

    public void printStep() {
        if (ObjectUtil.isNull((Object)this.executeStepsStr)) {
            this.executeStepsStr = this.getExecuteStepStr(true);
        }
        if (LiteflowConfigGetter.get().getPrintExecutionLog().booleanValue()) {
            LOG.info("CHAIN_NAME[{}]\n{}", (Object)this.getChainName(), (Object)this.executeStepsStr);
        }
    }

    public void generateRequestId() {
        this.metaDataMap.put(REQUEST_ID, IdGeneratorHolder.getInstance().generate());
    }

    public void putRequestId(String requestId) {
        this.metaDataMap.put(REQUEST_ID, requestId);
    }

    public String getRequestId() {
        return (String)this.metaDataMap.get(REQUEST_ID);
    }

    public Deque<CmpStep> getExecuteSteps() {
        return this.executeSteps;
    }

    public Exception getException() {
        return (Exception)this.metaDataMap.get(EXCEPTION);
    }

    public void setException(Exception e) {
        this.putMetaDataMap(EXCEPTION, e);
    }

    public void removeException() {
        this.metaDataMap.remove(EXCEPTION);
    }

    public Exception getSubException(String chainId) {
        return (Exception)this.metaDataMap.get(SUB_EXCEPTION_PREFIX + chainId);
    }

    public void setSubException(String chainId, Exception e) {
        this.putMetaDataMap(SUB_EXCEPTION_PREFIX + chainId, e);
    }

    public void removeSubException(String chainId) {
        this.metaDataMap.remove(SUB_EXCEPTION_PREFIX + chainId);
    }

    public List<Object> getContextBeanList() {
        return this.contextBeanList;
    }

    public <T> T getContextBean(Class<T> contextBeanClazz) {
        T t = this.contextBeanList.stream().filter(o -> o.getClass().getName().equals(contextBeanClazz.getName())).findFirst().orElse(null);
        if (t == null) {
            this.contextBeanList.forEach(o -> LOG.info("ChainId[{}], Context class:{},Request class:{}", this.getChainId(), o.getClass().getName(), contextBeanClazz.getName()));
            throw new NoSuchContextBeanException("this type is not in the context type passed in");
        }
        return t;
    }

    public <T> T getFirstContextBean() {
        Class<?> firstContextBeanClazz = this.getContextBeanList().get(0).getClass();
        return (T)this.getContextBean(firstContextBeanClazz);
    }

    public void addSubChain(String chainId) {
        Set subChainSet = (Set)this.metaDataMap.getOrDefault(SUB_CHAIN, new ConcurrentHashSet());
        subChainSet.add(chainId);
        this.metaDataMap.putIfAbsent(SUB_CHAIN, subChainSet);
    }

    public boolean isSubChain(String chainId) {
        if (this.metaDataMap.containsKey(SUB_CHAIN)) {
            Set subChainSet = (Set)this.metaDataMap.get(SUB_CHAIN);
            return subChainSet.contains(chainId);
        }
        return false;
    }
}

