/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.NoIteratorNodeException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.LoopCondition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.util.Iterator;

public class IteratorCondition
extends LoopCondition {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        Node iteratorNode = this.getIteratorNode();
        if (ObjectUtil.isNull((Object)iteratorNode)) {
            String errorInfo = StrUtil.format((CharSequence)"[{}]:no iterator-node found", (Object[])new Object[]{slot.getRequestId()});
            throw new NoIteratorNodeException(errorInfo);
        }
        if (!iteratorNode.isAccess(slotIndex)) {
            return;
        }
        iteratorNode.setCurrChainId(this.getCurrChainId());
        iteratorNode.execute(slotIndex);
        Iterator it = (Iterator)iteratorNode.getItemResultMetaValue(slotIndex);
        Executable executableItem = this.getDoExecutor();
        Executable breakItem = this.getBreakItem();
        try {
            int index = 0;
            while (it.hasNext()) {
                Object itObj = it.next();
                executableItem.setCurrChainId(this.getCurrChainId());
                this.setLoopIndex(executableItem, index);
                this.setCurrLoopObject(executableItem, itObj);
                executableItem.execute(slotIndex);
                if (ObjectUtil.isNotNull((Object)breakItem)) {
                    breakItem.setCurrChainId(this.getCurrChainId());
                    this.setLoopIndex(breakItem, index);
                    this.setCurrLoopObject(breakItem, itObj);
                    breakItem.execute(slotIndex);
                    boolean isBreak = (Boolean)breakItem.getItemResultMetaValue(slotIndex);
                    if (isBreak) {
                        break;
                    }
                }
                ++index;
            }
        }
        finally {
            this.removeLoopIndex(executableItem);
            this.removeCurrLoopObject(executableItem);
        }
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_ITERATOR;
    }

    public Node getIteratorNode() {
        return (Node)this.getExecutableOne("ITERATOR_KEY");
    }

    public void setIteratorNode(Node iteratorNode) {
        this.addExecutable("ITERATOR_KEY", iteratorNode);
    }
}

