/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.response;

import com.xxl.tool.response.ResponseCode;
import java.io.Serializable;

public class Response<T>
implements Serializable {
    public static final long serialVersionUID = 42L;
    private int code;
    private String msg;
    private T data;

    public Response() {
    }

    public Response(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Response(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "Response{code=" + this.code + ", msg='" + this.msg + "', data=" + this.data + "}";
    }

    public boolean isSuccess() {
        return this.code == ResponseCode.CODE_200.getCode();
    }

    public static <T> Response<T> of(int code, String msg, T data) {
        return new Response<T>(code, msg, data);
    }

    public static <T> Response<T> of(int code, String msg) {
        return new Response<Object>(code, msg, null);
    }

    public static <T> Response<T> ofSuccess(T data) {
        return new Response<T>(ResponseCode.CODE_200.getCode(), ResponseCode.CODE_200.getMsg(), data);
    }

    public static <T> Response<T> ofSuccess() {
        return new Response<Object>(ResponseCode.CODE_200.getCode(), ResponseCode.CODE_200.getMsg(), null);
    }

    public static <T> Response<T> ofFail(String msg) {
        return new Response<Object>(ResponseCode.CODE_203.getCode(), msg, null);
    }

    public static <T> Response<T> ofFail() {
        return new Response<Object>(ResponseCode.CODE_203.getCode(), ResponseCode.CODE_203.getMsg(), null);
    }
}

