/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.concurrent;

import com.xxl.tool.core.AssertTool;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public abstract class TokenBucket {
    protected double storedPermits;
    protected double maxPermits;
    protected double stableIntervalMicros;
    protected double permitsPerSecond;
    private long nextFreeTicketMicros = 0L;
    private final Stopwatch stopwatch = Stopwatch.createStarted();
    private volatile Object mutexDoNotUseDirectly;

    public static TokenBucket create(double permitsPerSecond) {
        SmoothBursty tokenBucket = new SmoothBursty(1.0);
        tokenBucket.setRate(permitsPerSecond);
        return tokenBucket;
    }

    public static TokenBucket create(double permitsPerSecond, Duration warmupPeriod) {
        return TokenBucket.create(permitsPerSecond, TokenBucket.toNanosSaturated(warmupPeriod), TimeUnit.NANOSECONDS);
    }

    public static TokenBucket create(double permitsPerSecond, long warmupPeriod, TimeUnit unit) {
        AssertTool.isTrue(warmupPeriod >= 0L, "warmupPeriod must not be negative: " + warmupPeriod);
        return TokenBucket.create(permitsPerSecond, warmupPeriod, unit, 3.0);
    }

    public static TokenBucket create(double permitsPerSecond, long warmupPeriod, TimeUnit unit, double coldFactor) {
        SmoothWarmingUp tokenBucket = new SmoothWarmingUp(warmupPeriod, unit, coldFactor);
        tokenBucket.setRate(permitsPerSecond);
        return tokenBucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object mutex() {
        Object mutex = this.mutexDoNotUseDirectly;
        if (mutex == null) {
            TokenBucket tokenBucket = this;
            synchronized (tokenBucket) {
                mutex = this.mutexDoNotUseDirectly;
                if (mutex == null) {
                    this.mutexDoNotUseDirectly = mutex = new Object();
                }
            }
        }
        return mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRate(double permitsPerSecond) {
        AssertTool.isTrue(permitsPerSecond > 0.0, "rate must be positive");
        Object object = this.mutex();
        synchronized (object) {
            this.resync(this.stopwatch.elapsed(TimeUnit.MICROSECONDS));
            this.permitsPerSecond = permitsPerSecond;
            this.stableIntervalMicros = (double)TimeUnit.SECONDS.toMicros(1L) / permitsPerSecond;
            this.doSetRate();
        }
    }

    abstract void doSetRate();

    void resync(long nowMicros) {
        if (nowMicros > this.nextFreeTicketMicros) {
            double newPermits = (double)(nowMicros - this.nextFreeTicketMicros) / this.coolDownIntervalMicros();
            this.storedPermits = Math.min(this.maxPermits, this.storedPermits + newPermits);
            this.nextFreeTicketMicros = nowMicros;
        }
    }

    abstract long storedPermitsToWaitTime(double var1);

    abstract double coolDownIntervalMicros();

    public double acquire() {
        return this.acquire(1);
    }

    public double acquire(int permits) {
        long microsToWait = this.reserve(permits);
        if (microsToWait > 0L) {
            TokenBucket.sleepUninterruptibly(microsToWait, TimeUnit.MICROSECONDS);
        }
        return 1.0 * (double)microsToWait / (double)TimeUnit.SECONDS.toMicros(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long reserve(int permits) {
        AssertTool.isTrue(permits > 0, "Requested permits must be positive, permits:" + permits);
        Object object = this.mutex();
        synchronized (object) {
            return this.reserveAndGetWaitLength(permits, this.stopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1, 0L, TimeUnit.MICROSECONDS);
    }

    public boolean tryAcquire(Duration timeout) {
        return this.tryAcquire(1, TokenBucket.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return this.tryAcquire(1, timeout, unit);
    }

    public boolean tryAcquire(int permits) {
        return this.tryAcquire(permits, 0L, TimeUnit.MICROSECONDS);
    }

    public boolean tryAcquire(int permits, Duration timeout) {
        return this.tryAcquire(permits, TokenBucket.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
        long microsToWait;
        long timeoutMicros = Math.max(unit.toMicros(timeout), 0L);
        AssertTool.isTrue(permits > 0, "Requested permits must be positive, permits:" + permits);
        Object object = this.mutex();
        synchronized (object) {
            long nowMicros = this.stopwatch.elapsed(TimeUnit.MICROSECONDS);
            if (!this.canAcquire(nowMicros, timeoutMicros)) {
                return false;
            }
            microsToWait = this.reserveAndGetWaitLength(permits, nowMicros);
        }
        if (microsToWait > 0L) {
            TokenBucket.sleepUninterruptibly(microsToWait, TimeUnit.MICROSECONDS);
        }
        return true;
    }

    private boolean canAcquire(long nowMicros, long timeoutMicros) {
        return this.nextFreeTicketMicros <= nowMicros + timeoutMicros;
    }

    final long reserveAndGetWaitLength(int permits, long nowMicros) {
        long momentAvailable = this.reserveEarliestAvailable(permits, nowMicros);
        return Math.max(momentAvailable - nowMicros, 0L);
    }

    final long reserveEarliestAvailable(int requiredPermits, long nowMicros) {
        this.resync(nowMicros);
        long returnValue = this.nextFreeTicketMicros;
        double storedPermitsToSpend = Math.min((double)requiredPermits, this.storedPermits);
        double freshPermits = (double)requiredPermits - storedPermitsToSpend;
        long waitMicros = this.storedPermitsToWaitTime(storedPermitsToSpend) + (long)(freshPermits * this.stableIntervalMicros);
        this.nextFreeTicketMicros = TokenBucket.saturatedAdd(this.nextFreeTicketMicros, waitMicros);
        this.storedPermits -= storedPermitsToSpend;
        return returnValue;
    }

    public String toString() {
        return String.format(Locale.ROOT, "TokenBucket[stableRate=%3.1fqps]", this.permitsPerSecond);
    }

    public static long toNanosSaturated(Duration duration) {
        try {
            return duration.toNanos();
        }
        catch (ArithmeticException tooBig) {
            return duration.isNegative() ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
    }

    public static String formatCompact4Digits(double value) {
        return String.format(Locale.ROOT, "%.4g", value);
    }

    public static void sleepUninterruptibly(long sleepFor, TimeUnit unit) {
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(sleepFor);
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(remainingNanos);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static long saturatedAdd(long a, long b) {
        long naiveSum;
        if ((a ^ b) < 0L | (a ^ (naiveSum = a + b)) >= 0L) {
            return naiveSum;
        }
        return Long.MAX_VALUE + (naiveSum >>> 63 ^ 1L);
    }

    public static final class Stopwatch {
        private boolean isRunning;
        private long elapsedNanos;
        private long startTick;

        public static Stopwatch createUnstarted() {
            return new Stopwatch();
        }

        public static Stopwatch createStarted() {
            return new Stopwatch().start();
        }

        Stopwatch() {
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public Stopwatch start() {
            AssertTool.isTrue(!this.isRunning, "This stopwatch is already running.");
            this.isRunning = true;
            this.startTick = System.nanoTime();
            return this;
        }

        public Stopwatch stop() {
            AssertTool.isTrue(this.isRunning, "This stopwatch is already stopped.");
            this.isRunning = false;
            this.elapsedNanos += System.nanoTime() - this.startTick;
            return this;
        }

        public Stopwatch reset() {
            this.elapsedNanos = 0L;
            this.isRunning = false;
            return this;
        }

        private long elapsedNanos() {
            return this.isRunning ? System.nanoTime() - this.startTick + this.elapsedNanos : this.elapsedNanos;
        }

        public long elapsed(TimeUnit desiredUnit) {
            return desiredUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
        }

        public Duration elapsed() {
            return Duration.ofNanos(this.elapsedNanos());
        }

        public String toString() {
            long nanos = this.elapsedNanos();
            TimeUnit unit = Stopwatch.chooseUnit(nanos);
            double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
            return TokenBucket.formatCompact4Digits(value) + " " + Stopwatch.abbreviate(unit);
        }

        private static TimeUnit chooseUnit(long nanos) {
            if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.DAYS;
            }
            if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.HOURS;
            }
            if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.MINUTES;
            }
            if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.SECONDS;
            }
            if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.MILLISECONDS;
            }
            if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.MICROSECONDS;
            }
            return TimeUnit.NANOSECONDS;
        }

        private static String abbreviate(TimeUnit unit) {
            switch (unit) {
                case NANOSECONDS: {
                    return "ns";
                }
                case MICROSECONDS: {
                    return "\u03bcs";
                }
                case MILLISECONDS: {
                    return "ms";
                }
                case SECONDS: {
                    return "s";
                }
                case MINUTES: {
                    return "min";
                }
                case HOURS: {
                    return "h";
                }
                case DAYS: {
                    return "d";
                }
            }
            throw new AssertionError();
        }
    }

    static final class SmoothBursty
    extends TokenBucket {
        final double maxBurstSeconds;

        SmoothBursty(double maxBurstSeconds) {
            this.maxBurstSeconds = maxBurstSeconds;
        }

        @Override
        void doSetRate() {
            double oldMaxPermits = this.maxPermits;
            this.maxPermits = this.maxBurstSeconds * this.permitsPerSecond;
            this.storedPermits = oldMaxPermits == Double.POSITIVE_INFINITY ? this.maxPermits : (oldMaxPermits == 0.0 ? 0.0 : this.storedPermits * this.maxPermits / oldMaxPermits);
        }

        @Override
        long storedPermitsToWaitTime(double permitsToTake) {
            return 0L;
        }

        @Override
        double coolDownIntervalMicros() {
            return this.stableIntervalMicros;
        }
    }

    static final class SmoothWarmingUp
    extends TokenBucket {
        private final long warmupPeriodMicros;
        private double slope;
        private double thresholdPermits;
        private double coldFactor;

        SmoothWarmingUp(long warmupPeriod, TimeUnit timeUnit, double coldFactor) {
            this.warmupPeriodMicros = timeUnit.toMicros(warmupPeriod);
            this.coldFactor = coldFactor;
        }

        @Override
        void doSetRate() {
            double oldMaxPermits = this.maxPermits;
            double coldIntervalMicros = this.stableIntervalMicros * this.coldFactor;
            this.thresholdPermits = 0.5 * (double)this.warmupPeriodMicros / this.stableIntervalMicros;
            this.maxPermits = this.thresholdPermits + 2.0 * (double)this.warmupPeriodMicros / (this.stableIntervalMicros + coldIntervalMicros);
            this.slope = (coldIntervalMicros - this.stableIntervalMicros) / (this.maxPermits - this.thresholdPermits);
            this.storedPermits = oldMaxPermits == Double.POSITIVE_INFINITY ? 0.0 : (oldMaxPermits == 0.0 ? this.maxPermits : this.storedPermits * this.maxPermits / oldMaxPermits);
        }

        @Override
        long storedPermitsToWaitTime(double permitsToTake) {
            double availablePermitsAboveThreshold = this.storedPermits - this.thresholdPermits;
            long micros = 0L;
            if (availablePermitsAboveThreshold > 0.0) {
                double permitsAboveThresholdToTake = Math.min(availablePermitsAboveThreshold, permitsToTake);
                double length = this.permitsToTime(availablePermitsAboveThreshold) + this.permitsToTime(availablePermitsAboveThreshold - permitsAboveThresholdToTake);
                micros = (long)(permitsAboveThresholdToTake * length / 2.0);
                permitsToTake -= permitsAboveThresholdToTake;
            }
            return micros += (long)(this.stableIntervalMicros * permitsToTake);
        }

        private double permitsToTime(double permits) {
            return this.stableIntervalMicros + permits * this.slope;
        }

        @Override
        double coolDownIntervalMicros() {
            return (double)this.warmupPeriodMicros / this.maxPermits;
        }
    }
}

