/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.cache.impl;

import com.xxl.tool.cache.iface.Cache;
import com.xxl.tool.cache.iface.CacheListener;
import com.xxl.tool.cache.iface.CacheLoader;
import com.xxl.tool.cache.model.CacheKey;
import com.xxl.tool.cache.model.CacheObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReentrantCache<K, V>
implements Cache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(ReentrantCache.class);
    private static final long serialVersionUID = 42L;
    protected long timeout;
    protected int capacity;
    protected boolean expireType;
    protected final ConcurrentMap<Long, Lock> writeLockMap = new ConcurrentHashMap<Long, Lock>();
    protected final int writeLockCount = 100;
    protected volatile Map<CacheKey<K>, CacheObject<K, V>> cacheMap;
    protected LongAdder hitCount = new LongAdder();
    protected LongAdder missCount = new LongAdder();
    protected CacheListener<K, V> listener;
    protected CacheLoader<K, V> loader;

    private Lock getKeyLock(K key) {
        long keyHash = key != null ? (long)(key.hashCode() % 100) : -1L;
        return this.writeLockMap.computeIfAbsent(keyHash, k -> new ReentrantLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object) {
        if (key == null) {
            return;
        }
        Lock writeLock = this.getKeyLock(key);
        writeLock.lock();
        try {
            CacheKey<K> cacheKey = CacheKey.of(key);
            CacheObject<K, V> cacheObject = new CacheObject<K, V>(key, object, this.timeout, this.expireType);
            if (this.cacheMap.containsKey(cacheKey)) {
                this.cacheMap.put(cacheKey, cacheObject);
            } else {
                if (this.isFull()) {
                    this.doPrune();
                }
                this.cacheMap.put(cacheKey, cacheObject);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public V get(K key) {
        return this.get(key, this.loader);
    }

    @Override
    public V getIfPresent(K key) {
        return this.get(key, null);
    }

    @Override
    public V get(K key, CacheLoader<K, V> cacheLoader) {
        V v = this.getOrRemoveExpired(key, true, true);
        if (null == v && null != cacheLoader) {
            Lock writeLock = this.getKeyLock(key);
            writeLock.lock();
            try {
                v = this.getOrRemoveExpired(key, true, false);
                if (null == v) {
                    v = cacheLoader.load(key);
                    this.put(key, v);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                writeLock.unlock();
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getOrRemoveExpired(K key, boolean isUpdateLastAccess, boolean isUpdateCount) {
        CacheObject<K, V> cacheObject;
        Lock writeLock = this.getKeyLock(key);
        writeLock.lock();
        try {
            cacheObject = this.cacheMap.get(CacheKey.of(key));
            if (null != cacheObject && cacheObject.isExpired()) {
                this.removeWithoutLock(key);
                this.onRemove(cacheObject);
                cacheObject = null;
            }
        }
        finally {
            writeLock.unlock();
        }
        if (isUpdateCount) {
            if (null == cacheObject) {
                this.missCount.increment();
            } else {
                this.hitCount.increment();
            }
        }
        if (cacheObject == null) {
            return null;
        }
        return cacheObject.get(isUpdateLastAccess);
    }

    @Override
    public boolean containsKey(K key) {
        return null != this.getOrRemoveExpired(key, false, false);
    }

    @Override
    public Map<K, V> asMap() {
        return this.cacheMap.values().stream().filter(cacheObject -> !cacheObject.isExpired()).collect(Collectors.toMap(CacheObject::getKey, CacheObject::getValue));
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isFull() {
        return this.capacity > 0 && this.cacheMap.size() >= this.capacity;
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        CacheObject<K, V> cacheObject;
        Lock writeLock = this.getKeyLock(key);
        writeLock.lock();
        try {
            cacheObject = this.removeWithoutLock(key);
        }
        finally {
            writeLock.unlock();
        }
        this.onRemove(cacheObject);
    }

    protected CacheObject<K, V> removeWithoutLock(K key) {
        return this.cacheMap.remove(CacheKey.of(key));
    }

    protected void onRemove(CacheObject<K, V> cacheObject) {
        if (this.listener != null && cacheObject != null) {
            try {
                this.listener.onRemove(cacheObject.getKey(), cacheObject.getValue());
            }
            catch (Exception e) {
                logger.error("cache listener onRemove error, cacheObject:{}", cacheObject, (Object)e);
            }
        }
    }

    @Override
    public final int prune() {
        Lock writeLock = this.getKeyLock(null);
        writeLock.lock();
        try {
            int n = this.doPrune();
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    protected abstract int doPrune();

    @Override
    public void clear() {
        Lock writeLock = this.getKeyLock(null);
        writeLock.lock();
        try {
            this.cacheMap.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public long hitCount() {
        return this.hitCount.sum();
    }

    @Override
    public long missCount() {
        return this.missCount.sum();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public ReentrantCache<K, V> setListener(CacheListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public ReentrantCache<K, V> setLoader(CacheLoader<K, V> loader) {
        this.loader = loader;
        return this;
    }

    public String toString() {
        Lock writeLock = this.getKeyLock(null);
        writeLock.lock();
        try {
            String string = this.cacheMap.toString();
            return string;
        }
        finally {
            writeLock.unlock();
        }
    }
}

