/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.cache.impl;

import com.xxl.tool.cache.impl.ReentrantCache;
import com.xxl.tool.cache.model.CacheObject;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class FIFOCache<K, V>
extends ReentrantCache<K, V> {
    private static final long serialVersionUID = 42L;

    public FIFOCache(int capacity, long timeout, boolean expireType) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must large than 0");
        }
        if (Integer.MAX_VALUE == capacity) {
            --capacity;
        }
        this.capacity = capacity;
        this.timeout = timeout;
        this.expireType = expireType;
        this.cacheMap = new LinkedHashMap(capacity + 1, 1.0f, false);
    }

    @Override
    protected int doPrune() {
        int count = 0;
        CacheObject first = null;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheObject cacheObject = values.next();
            if (cacheObject.isExpired()) {
                values.remove();
                this.onRemove(cacheObject);
                ++count;
                continue;
            }
            if (first != null) continue;
            first = cacheObject;
        }
        if (this.isFull() && null != first) {
            this.removeWithoutLock(first.getKey());
            this.onRemove(first);
            ++count;
        }
        return count;
    }
}

