/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.freemarker;

import com.xxl.tool.exception.BizException;
import freemarker.core.TemplateClassResolver;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerTool {
    private static final Logger logger = LoggerFactory.getLogger(FreemarkerTool.class);
    private static Configuration freemarkerConfig = null;
    private static BeansWrapper wrapper = new BeansWrapperBuilder(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS).build();

    public static void init(String templatePath) {
        try {
            freemarkerConfig = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            freemarkerConfig.setDirectoryForTemplateLoading(new File(templatePath));
            freemarkerConfig.setDefaultEncoding("UTF-8");
            freemarkerConfig.setNumberFormat("0.##########");
            freemarkerConfig.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
            freemarkerConfig.setClassicCompatible(true);
            freemarkerConfig.setLocale(Locale.CHINA);
            freemarkerConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void init(Configuration freemarkerConfig) {
        FreemarkerTool.freemarkerConfig = freemarkerConfig;
    }

    public static String processTemplateIntoString(Template template, Object model) throws IOException, TemplateException {
        StringWriter result = new StringWriter();
        template.process(model, (Writer)result);
        return result.toString();
    }

    public static String processString(String templateName, Map<String, Object> params) throws IOException, TemplateException {
        Template template = freemarkerConfig.getTemplate(templateName);
        String htmlText = FreemarkerTool.processTemplateIntoString(template, params);
        return htmlText;
    }

    public static String processString(Configuration freemarkerConfig, String templateName, Map<String, Object> params) throws IOException, TemplateException {
        Template template = freemarkerConfig.getTemplate(templateName);
        String htmlText = FreemarkerTool.processTemplateIntoString(template, params);
        return htmlText;
    }

    public static TemplateHashModel generateStaticModel(String packageName) {
        try {
            TemplateHashModel staticModels = wrapper.getStaticModels();
            TemplateHashModel fileStatics = (TemplateHashModel)staticModels.get(packageName);
            return fileStatics;
        }
        catch (Exception e) {
            throw new BizException(e);
        }
    }
}

