/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.fiber.callback;

import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.SuspendExecution;
import java.util.concurrent.TimeUnit;

public abstract class AbstractFiberCallback {
    private volatile Fiber fiber = Fiber.currentFiber();
    public volatile int status = -1;
    public volatile Object result;
    public volatile Throwable exception;

    public void onFiberSuccess(Object result) {
        try {
            this.result = result;
            this.status = 1;
        }
        finally {
            this.fiber.unpark();
        }
    }

    public void onFiberFailure(Throwable exception) {
        try {
            this.exception = exception;
            this.status = 0;
        }
        finally {
            this.fiber.unpark();
        }
    }

    public Object get(int maxWaitSeconds) throws SuspendExecution {
        Fiber.park((long)maxWaitSeconds, (TimeUnit)TimeUnit.SECONDS);
        if (this.status == 1) {
            return this.result;
        }
        if (this.status == 0) {
            throw new RuntimeException(this.exception);
        }
        throw new RuntimeException("fiber request timeout");
    }
}

