/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.emoji.factory;

import com.xxl.tool.emoji.exception.XxlEmojiException;
import com.xxl.tool.emoji.loader.EmojiDataLoader;
import com.xxl.tool.emoji.loader.EmojiTrie;
import com.xxl.tool.emoji.loader.impl.LocalEmojiDataLoader;
import com.xxl.tool.emoji.model.AliasCandidate;
import com.xxl.tool.emoji.model.Emoji;
import com.xxl.tool.emoji.model.UnicodeCandidate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmojiFactory {
    private static List<Emoji> ALL_EMOJIS = null;
    private static EmojiTrie EMOJI_TRIE = null;
    private static Map<String, Emoji> EMOJIS_BY_ALIAS = null;
    private static Map<String, Set<Emoji>> EMOJIS_BY_TAG = null;
    private static EmojiDataLoader emojiLoader = new LocalEmojiDataLoader();
    private static final Pattern ALIAS_CANDIDATE_PATTERN;

    public static void setEmojiLoader(EmojiDataLoader emojiLoader) {
        EmojiFactory.emojiLoader = emojiLoader;
    }

    public static void loadEmoji() {
        List<Emoji> emojis = emojiLoader.loadEmojiData();
        if (emojis == null || emojis.size() == 0) {
            throw new XxlEmojiException("emoji loader fail");
        }
        ALL_EMOJIS = emojis;
        EMOJI_TRIE = new EmojiTrie(ALL_EMOJIS);
        EMOJIS_BY_ALIAS = new HashMap<String, Emoji>();
        EMOJIS_BY_TAG = new HashMap<String, Set<Emoji>>();
        for (Emoji emoji : ALL_EMOJIS) {
            for (String alias : emoji.getAliases()) {
                EMOJIS_BY_ALIAS.put(alias, emoji);
            }
            for (String tag : emoji.getTags()) {
                if (EMOJIS_BY_TAG.get(tag) == null) {
                    EMOJIS_BY_TAG.put(tag, new HashSet());
                }
                EMOJIS_BY_TAG.get(tag).add(emoji);
            }
        }
    }

    public static Emoji getForAlias(String alias) {
        if (alias == null) {
            return null;
        }
        return EMOJIS_BY_ALIAS.get(EmojiFactory.trimAlias(alias));
    }

    private static String trimAlias(String alias) {
        String result = alias;
        if (result.startsWith(":")) {
            result = result.substring(1, result.length());
        }
        if (result.endsWith(":")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static Set<Emoji> getForTag(String tag) {
        if (tag == null) {
            return null;
        }
        return EMOJIS_BY_TAG.get(tag);
    }

    public static Set<String> getAllTags() {
        return EMOJIS_BY_TAG.keySet();
    }

    public static Emoji getByUnicode(String unicode) {
        if (unicode == null) {
            return null;
        }
        return EMOJI_TRIE.getEmoji(unicode);
    }

    public static List<Emoji> getAll() {
        return ALL_EMOJIS;
    }

    public static List<AliasCandidate> getAliasCandidates(String input) {
        ArrayList<AliasCandidate> candidates = new ArrayList<AliasCandidate>();
        Matcher matcher = ALIAS_CANDIDATE_PATTERN.matcher(input);
        matcher = matcher.useTransparentBounds(true);
        while (matcher.find()) {
            String match = matcher.group();
            if (!match.contains("|")) {
                candidates.add(new AliasCandidate(match, match, null));
                continue;
            }
            String[] splitted = match.split("\\|");
            if (splitted.length == 2 || splitted.length > 2) {
                candidates.add(new AliasCandidate(match, splitted[0], splitted[1]));
                continue;
            }
            candidates.add(new AliasCandidate(match, match, null));
        }
        return candidates;
    }

    public static List<UnicodeCandidate> getUnicodeCandidates(String input) {
        UnicodeCandidate next;
        char[] inputCharArray = input.toCharArray();
        ArrayList<UnicodeCandidate> candidates = new ArrayList<UnicodeCandidate>();
        int i = 0;
        while ((next = EmojiFactory.getNextUnicodeCandidate(inputCharArray, i)) != null) {
            candidates.add(next);
            i = next.getFitzpatrickEndIndex();
        }
        return candidates;
    }

    protected static UnicodeCandidate getNextUnicodeCandidate(char[] chars, int start) {
        for (int i = start; i < chars.length; ++i) {
            int emojiEnd = EmojiFactory.getFirstEmojiEndPos(chars, i);
            if (emojiEnd == -1) continue;
            Emoji emoji = EmojiFactory.getByUnicode(new String(chars, i, emojiEnd - i));
            String fitzpatrickString = emojiEnd + 2 <= chars.length ? new String(chars, emojiEnd, 2) : null;
            return new UnicodeCandidate(emoji, fitzpatrickString, i);
        }
        return null;
    }

    protected static int getFirstEmojiEndPos(char[] text, int startPos) {
        int best = -1;
        for (int j = startPos + 1; j <= text.length; ++j) {
            EmojiTrie.Matches status = EMOJI_TRIE.isEmoji(Arrays.copyOfRange(text, startPos, j));
            if (status.exactMatch()) {
                best = j;
                continue;
            }
            if (!status.impossibleMatch()) continue;
            return best;
        }
        return best;
    }

    static {
        EmojiFactory.loadEmoji();
        ALIAS_CANDIDATE_PATTERN = Pattern.compile("(?<=:)\\+?(\\w|\\||\\-)+(?=:)");
    }
}

