/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.store.impl;

import com.xxl.sso.core.model.LoginInfo;
import com.xxl.sso.core.store.LoginStore;
import com.xxl.sso.core.util.JedisTool;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.response.Response;

public class RedisLoginStore
implements LoginStore {
    private JedisTool jedisTool;
    private String storeKeyPrefix;

    public RedisLoginStore(String nodes, String user, String password, String storeKeyPrefix) {
        this.jedisTool = new JedisTool(nodes, user, password);
        this.storeKeyPrefix = (StringTool.isNotBlank((String)storeKeyPrefix) ? storeKeyPrefix.trim() : "xxl_sso") + ":";
    }

    private String parseStoreKey(String userId) {
        return this.storeKeyPrefix + userId;
    }

    private String parseTicketStoreKey(String ticket) {
        if (ticket == null) {
            return null;
        }
        return this.storeKeyPrefix + "ticket:" + ticket;
    }

    @Override
    public void start() {
        this.jedisTool.start();
    }

    @Override
    public void stop() {
        this.jedisTool.stop();
    }

    @Override
    public Response<String> set(LoginInfo loginInfo) {
        if (loginInfo == null || StringTool.isBlank((String)loginInfo.getUserId()) || StringTool.isBlank((String)loginInfo.getSignature())) {
            return Response.ofFail((String)"loginInfo invalid.");
        }
        if (loginInfo.getExpireTime() < System.currentTimeMillis()) {
            return Response.ofFail((String)"expireTime invalid.");
        }
        long seconds = (loginInfo.getExpireTime() - System.currentTimeMillis()) / 1000L;
        String storeKey = this.parseStoreKey(loginInfo.getUserId());
        this.jedisTool.set(storeKey, loginInfo, seconds);
        return Response.ofSuccess();
    }

    @Override
    public Response<String> update(LoginInfo loginInfo) {
        if (loginInfo == null || StringTool.isBlank((String)loginInfo.getUserId())) {
            return Response.ofFail((String)"loginInfo invalid.");
        }
        String storeKey = this.parseStoreKey(loginInfo.getUserId());
        if (loginInfo.getExpireTime() < System.currentTimeMillis()) {
            return Response.ofFail((String)"expireTime invalid.");
        }
        LoginInfo loginInfoStore = (LoginInfo)this.jedisTool.get(storeKey);
        if (loginInfoStore == null) {
            return Response.ofFail((String)"loginInfo not exists.");
        }
        loginInfoStore.setUserName(loginInfo.getUserName());
        loginInfoStore.setRealName(loginInfo.getRealName());
        loginInfoStore.setExtraInfo(loginInfo.getExtraInfo());
        loginInfoStore.setRoleList(loginInfo.getRoleList());
        loginInfoStore.setPermissionList(loginInfo.getPermissionList());
        loginInfoStore.setExpireTime(loginInfo.getExpireTime());
        long seconds = (loginInfo.getExpireTime() - System.currentTimeMillis()) / 1000L;
        this.jedisTool.set(storeKey, loginInfoStore, seconds);
        return Response.ofSuccess();
    }

    @Override
    public Response<String> remove(String userId) {
        if (StringTool.isBlank((String)userId)) {
            return Response.ofFail((String)"userId invalid.");
        }
        String storeKey = this.parseStoreKey(userId);
        this.jedisTool.del(storeKey);
        return Response.ofSuccess();
    }

    @Override
    public Response<LoginInfo> get(String userId) {
        if (StringTool.isBlank((String)userId)) {
            return Response.ofFail((String)"userId invalid.");
        }
        String storeKey = this.parseStoreKey(userId);
        LoginInfo loginInfo = (LoginInfo)this.jedisTool.get(storeKey);
        if (loginInfo == null) {
            return Response.ofFail((String)"loginInfo not exists.");
        }
        if (loginInfo.getExpireTime() < System.currentTimeMillis()) {
            this.jedisTool.del(storeKey);
            return Response.ofFail((String)"loginInfo is timeout");
        }
        return Response.ofSuccess((Object)loginInfo);
    }

    @Override
    public Response<String> createTicket(String ticket, String token, long ticketTimeout) {
        if (StringTool.isBlank((String)ticket)) {
            return Response.ofFail((String)"ticket is invalid");
        }
        if (ticketTimeout < 1000L || ticketTimeout > 180000L) {
            return Response.ofFail((String)"ticketTimeout is invalid");
        }
        String storeKey = this.parseTicketStoreKey(ticket);
        this.jedisTool.set(storeKey, token, ticketTimeout);
        return Response.ofSuccess((Object)ticket);
    }

    @Override
    public Response<String> validTicket(String ticket) {
        String storeKey = this.parseTicketStoreKey(ticket);
        String token = (String)this.jedisTool.get(storeKey);
        if (StringTool.isBlank((String)token)) {
            return Response.ofFail((String)"ticket not found.");
        }
        return Response.ofSuccess((Object)token);
    }
}

