/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert.impl;

import com.xiaoleilu.hutool.bean.BeanUtil;
import com.xiaoleilu.hutool.convert.AbstractConverter;
import com.xiaoleilu.hutool.convert.ConverterRegistry;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.Map;

public class MapConverter
extends AbstractConverter<Map<?, ?>> {
    private final Class<?> mapType;
    private final Class<?> keyType;
    private final Class<?> valueType;

    public MapConverter(Class<?> mapType) {
        this.mapType = mapType;
        this.keyType = ClassUtil.getTypeArgument(mapType, 0);
        this.valueType = ClassUtil.getTypeArgument(mapType, 1);
    }

    public MapConverter(Class<?> mapType, Class<?> keyType, Class<?> valueType) {
        this.mapType = mapType;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    protected Map<?, ?> convertInternal(Object value) {
        Map<Object, Object> map = CollectionUtil.createMap(this.mapType);
        Class<?> valueType = value.getClass();
        if (value instanceof Map) {
            this.convertMapToMap((Map)value, map);
        } else if (BeanUtil.isBean(valueType)) {
            BeanUtil.beanToMap(map);
        } else {
            throw new UnsupportedOperationException(StrUtil.format((CharSequence)"Unsupport toMap value type: {}", valueType.getName()));
        }
        return map;
    }

    private void convertMapToMap(Map<?, ?> srcMap, Map<Object, Object> targetMap) {
        ConverterRegistry convert = ConverterRegistry.getInstance();
        for (Map.Entry<?, ?> entry : srcMap.entrySet()) {
            targetMap.put(convert.convert(this.keyType, entry.getKey()), convert.convert(this.valueType, entry.getValue()));
        }
    }
}

