/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert.impl;

import com.xiaoleilu.hutool.convert.AbstractConverter;
import com.xiaoleilu.hutool.convert.ConverterRegistry;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArrayConverter
extends AbstractConverter<Object> {
    private final Class<?> targetComponentType;

    public ArrayConverter(Class<?> targetComponentType) {
        this.targetComponentType = targetComponentType;
    }

    @Override
    protected Object convertInternal(Object value) {
        return value.getClass().isArray() ? this.convertArrayToArray(value) : this.convertObjectToArray(value);
    }

    @Override
    public Class getTargetType() {
        return this.targetComponentType;
    }

    private Object convertArrayToArray(Object array) {
        Class<?> valueComponentType = array.getClass().getComponentType();
        if (valueComponentType == this.targetComponentType) {
            return array;
        }
        int len = ArrayUtil.length(array);
        Object result = Array.newInstance(this.targetComponentType, len);
        ConverterRegistry converter = ConverterRegistry.getInstance();
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, converter.convert(this.targetComponentType, Array.get(array, i)));
        }
        return result;
    }

    private Object convertObjectToArray(Object value) {
        if (value instanceof CharSequence) {
            if (this.targetComponentType == Character.TYPE || this.targetComponentType == Character.class) {
                return this.convertArrayToArray(value.toString().toCharArray());
            }
            String[] strings = StrUtil.split((CharSequence)value.toString(), ",");
            return this.convertArrayToArray(strings);
        }
        ConverterRegistry converter = ConverterRegistry.getInstance();
        Object[] result = null;
        if (value instanceof List) {
            List list = (List)value;
            result = ArrayUtil.newArray(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                result[i] = converter.convert(this.targetComponentType, list.get(i));
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            result = ArrayUtil.newArray(this.targetComponentType, collection.size());
            int i = 0;
            for (Object element : collection) {
                result[i] = converter.convert(this.targetComponentType, element);
                ++i;
            }
        } else if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            ArrayList list = new ArrayList();
            for (Object element : iterable) {
                list.add(converter.convert(this.targetComponentType, element));
            }
            result = ArrayUtil.newArray(this.targetComponentType, list.size());
            result = list.toArray(result);
        } else {
            result = this.convertToSingleElementArray(value);
        }
        return result;
    }

    private Object[] convertToSingleElementArray(Object value) {
        Object[] singleElementArray = ArrayUtil.newArray(this.targetComponentType, 1);
        singleElementArray[0] = ConverterRegistry.getInstance().convert(this.targetComponentType, value);
        return singleElementArray;
    }
}

