/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.comparator;

import com.xiaoleilu.hutool.bean.BeanUtil;
import com.xiaoleilu.hutool.comparator.ComparatorException;
import com.xiaoleilu.hutool.util.ObjectUtil;
import java.io.Serializable;
import java.util.Comparator;

public class PropertyComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 9157326766723846313L;
    private final String property;

    public PropertyComparator(String property) {
        this.property = property;
    }

    @Override
    public int compare(T o1, T o2) {
        Comparable v2;
        Comparable v1;
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return 1;
        }
        if (null == o2) {
            return -1;
        }
        try {
            v1 = (Comparable)BeanUtil.getProperty(o1, this.property);
            v2 = (Comparable)BeanUtil.getProperty(o1, this.property);
        }
        catch (Exception e) {
            throw new ComparatorException(e);
        }
        return this.compare(o1, o2, v1, v2);
    }

    private int compare(T o1, T o2, Comparable fieldValue1, Comparable fieldValue2) {
        int result = ObjectUtil.compare(fieldValue1, fieldValue2);
        if (0 == result && ObjectUtil.notEqual(o1, o2)) {
            return 1;
        }
        return result;
    }
}

