/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log.dialect.tinylog;

import com.xiaoleilu.hutool.log.AbstractLog;
import com.xiaoleilu.hutool.log.level.Level;
import com.xiaoleilu.hutool.util.StrUtil;
import org.pmw.tinylog.Logger;

public class TinyLog
extends AbstractLog {
    private static final long serialVersionUID = -4848042277045993735L;
    private int level;
    private String name;

    public TinyLog(Class<?> clazz) {
        this.name = clazz.getName();
        this.level = Logger.getLevel((String)this.name).ordinal();
    }

    public TinyLog(String name) {
        this.name = name;
        this.level = Logger.getLevel((String)name).ordinal();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level <= org.pmw.tinylog.Level.TRACE.ordinal();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        Logger.trace((String)format, (Object[])arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        Logger.trace((Throwable)t, (String)format, (Object[])arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level <= org.pmw.tinylog.Level.DEBUG.ordinal();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        Logger.debug((String)format, (Object[])arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        Logger.debug((Throwable)t, (String)format, (Object[])arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.level <= org.pmw.tinylog.Level.INFO.ordinal();
    }

    @Override
    public void info(String format, Object ... arguments) {
        Logger.info((String)format, (Object[])arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        Logger.info((Throwable)t, (String)format, (Object[])arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.level <= org.pmw.tinylog.Level.WARNING.ordinal();
    }

    @Override
    public void warn(String format, Object ... arguments) {
        Logger.warn((String)format, (Object[])arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        Logger.warn((Throwable)t, (String)format, (Object[])arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level <= org.pmw.tinylog.Level.ERROR.ordinal();
    }

    @Override
    public void error(String format, Object ... arguments) {
        Logger.error((String)format, (Object[])arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        Logger.error((Throwable)t, (String)format, (Object[])arguments);
    }

    @Override
    public void log(Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    @Override
    public void log(Level level, Throwable t, String format, Object ... arguments) {
        switch (level) {
            case TRACE: {
                this.trace(t, format, arguments);
                break;
            }
            case DEBUG: {
                this.debug(t, format, arguments);
                break;
            }
            case INFO: {
                this.info(t, format, arguments);
                break;
            }
            case WARN: {
                this.warn(t, format, arguments);
                break;
            }
            case ERROR: {
                this.error(t, format, arguments);
                break;
            }
            default: {
                throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", new Object[]{level}));
            }
        }
    }
}

