/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.http.Header;
import com.xiaoleilu.hutool.http.HttpBase;
import com.xiaoleilu.hutool.http.HttpConnection;
import com.xiaoleilu.hutool.http.HttpException;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.io.FastByteArrayOutputStream;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class HttpResponse
extends HttpBase<HttpResponse> {
    private FastByteArrayOutputStream out;
    private int status;

    protected HttpResponse() {
    }

    public int getStatus() {
        return this.status;
    }

    public String contentEncoding() {
        return this.header(Header.CONTENT_ENCODING);
    }

    public boolean isGzip() {
        String contentEncoding = this.contentEncoding();
        return contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip");
    }

    public InputStream bodyStream() {
        return new ByteArrayInputStream(this.out.toByteArray());
    }

    public byte[] bodyBytes() {
        if (null == this.out) {
            return null;
        }
        return this.out.toByteArray();
    }

    public String body() throws HttpException {
        try {
            return HttpUtil.getString(this.bodyStream(), this.charset, null == this.charset);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = StrUtil.builder();
        sb.append("Request Headers: ").append("\r\n");
        for (Map.Entry entry : this.headers.entrySet()) {
            sb.append("    ").append(entry).append("\r\n");
        }
        sb.append("Request Body: ").append("\r\n");
        sb.append("    ").append(this.body()).append("\r\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HttpResponse readResponse(HttpConnection httpConnection) {
        HttpResponse httpResponse;
        block6: {
            httpResponse = new HttpResponse();
            InputStream in = null;
            try {
                httpResponse.status = httpConnection.responseCode();
                httpResponse.headers = httpConnection.headers();
                httpResponse.charset = httpConnection.charset();
                in = httpResponse.status < 400 ? httpConnection.getInputStream() : httpConnection.getErrorStream();
                httpResponse.readBody(in);
                IoUtil.close(in);
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    break block6;
                }
                throw new HttpException(e.getMessage(), e);
            }
            finally {
                IoUtil.close(in);
            }
        }
        return httpResponse;
    }

    private void readBody(InputStream in) throws IOException {
        int contentLength;
        if (this.isGzip()) {
            in = new GZIPInputStream(in);
        }
        this.out = (contentLength = Convert.toInt(this.header(Header.CONTENT_LENGTH), 0).intValue()) > 0 ? new FastByteArrayOutputStream(contentLength) : new FastByteArrayOutputStream();
        try {
            IoUtil.copy(in, this.out);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }
}

