/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.sql;

import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.sql.Condition;
import com.xiaoleilu.hutool.lang.Editor;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class Wrapper {
    private Character preWrapQuote;
    private Character sufWrapQuote;

    public Wrapper() {
    }

    public Wrapper(Character wrapQuote) {
        this.preWrapQuote = wrapQuote;
        this.sufWrapQuote = wrapQuote;
    }

    public Wrapper(Character preWrapQuote, Character sufWrapQuote) {
        this.preWrapQuote = preWrapQuote;
        this.sufWrapQuote = sufWrapQuote;
    }

    public char getPreWrapQuote() {
        return this.preWrapQuote.charValue();
    }

    public void setPreWrapQuote(Character preWrapQuote) {
        this.preWrapQuote = preWrapQuote;
    }

    public char getSufWrapQuote() {
        return this.sufWrapQuote.charValue();
    }

    public void setSufWrapQuote(Character sufWrapQuote) {
        this.sufWrapQuote = sufWrapQuote;
    }

    public String wrap(String field) {
        if (this.preWrapQuote == null || this.sufWrapQuote == null || StrUtil.isBlank(field)) {
            return field;
        }
        if (StrUtil.isSurround((CharSequence)field, this.preWrapQuote.charValue(), this.sufWrapQuote.charValue())) {
            return field;
        }
        if (field.contains("*") || field.contains("(")) {
            return field;
        }
        if (field.contains(".")) {
            Collection<String> target = CollectionUtil.filter(StrUtil.split((CharSequence)field, '.'), new Editor<String>(){

                @Override
                public String edit(String t) {
                    return StrUtil.format((CharSequence)"{}{}{}", Wrapper.this.preWrapQuote, t, Wrapper.this.sufWrapQuote);
                }
            });
            return CollectionUtil.join(target, (CharSequence)".");
        }
        return StrUtil.format((CharSequence)"{}{}{}", this.preWrapQuote, field, this.sufWrapQuote);
    }

    public String[] wrap(String ... fields) {
        if (ArrayUtil.isEmpty(fields)) {
            return fields;
        }
        String[] wrappedFields = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            wrappedFields[i] = this.wrap(fields[i]);
        }
        return wrappedFields;
    }

    public Collection<String> wrap(Collection<String> fields) {
        if (CollectionUtil.isEmpty(fields)) {
            return fields;
        }
        return Arrays.asList(this.wrap(fields.toArray(new String[fields.size()])));
    }

    public Entity wrap(Entity entity) {
        if (null == entity) {
            return null;
        }
        Entity wrapedEntity = new Entity();
        wrapedEntity.setTableName(this.wrap(entity.getTableName()));
        for (Map.Entry entry : entity.entrySet()) {
            wrapedEntity.set(this.wrap((String)entry.getKey()), entry.getValue());
        }
        return wrapedEntity;
    }

    public Condition[] wrap(Condition ... conditions) {
        Condition[] clonedConditions = new Condition[conditions.length];
        if (ArrayUtil.isNotEmpty(conditions)) {
            for (int i = 0; i < conditions.length; ++i) {
                Condition clonedCondition = conditions[i].clone();
                clonedCondition.setField(this.wrap(clonedCondition.getField()));
                clonedConditions[i] = clonedCondition;
            }
        }
        return clonedConditions;
    }
}

