/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.PageResult;
import com.xiaoleilu.hutool.db.SqlRunner;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.db.handler.EntityHandler;
import com.xiaoleilu.hutool.db.handler.EntityListHandler;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;

public class DaoTemplate {
    protected String tableName;
    protected String primaryKeyField = "id";
    protected SqlRunner runner;

    public DaoTemplate(String tableName) {
        this(tableName, (String)null);
    }

    public DaoTemplate(String tableName, String primaryKeyField) {
        this(tableName, primaryKeyField, DSFactory.get());
    }

    public DaoTemplate(String tableName, DataSource ds) {
        this(tableName, null, ds);
    }

    public DaoTemplate(String tableName, String primaryKeyField, DataSource ds) {
        this(tableName, primaryKeyField, DbUtil.newSqlRunner(ds));
    }

    public DaoTemplate(String tableName, String primaryKeyField, SqlRunner runner) {
        this.tableName = tableName;
        if (StrUtil.isNotBlank(primaryKeyField)) {
            this.primaryKeyField = primaryKeyField;
        }
        this.runner = runner;
    }

    public int add(Entity entity) throws SQLException {
        return this.runner.insert(this.fixEntity(entity));
    }

    public List<Object> addForGeneratedKeys(Entity entity) throws SQLException {
        return this.runner.insertForGeneratedKeys(this.fixEntity(entity));
    }

    public Long addForGeneratedKey(Entity entity) throws SQLException {
        return this.runner.insertForGeneratedKey(this.fixEntity(entity));
    }

    public <T> int del(T pk) throws SQLException {
        if (pk == null) {
            return 0;
        }
        return this.del(Entity.create(this.tableName).set(this.primaryKeyField, pk));
    }

    public <T> int del(String field, T value) throws SQLException {
        if (StrUtil.isBlank(field)) {
            return 0;
        }
        return this.del(Entity.create(this.tableName).set(field, value));
    }

    public <T> int del(Entity where) throws SQLException {
        if (CollectionUtil.isEmpty(where)) {
            return 0;
        }
        return this.runner.del(this.fixEntity(where));
    }

    public int update(Entity record, Entity where) throws SQLException {
        if (CollectionUtil.isEmpty(record)) {
            return 0;
        }
        return this.runner.update(this.fixEntity(record), where);
    }

    public int update(Entity entity) throws SQLException {
        if (CollectionUtil.isEmpty(entity)) {
            return 0;
        }
        Object pk = (entity = this.fixEntity(entity)).get(this.primaryKeyField);
        if (null == pk) {
            throw new SQLException(StrUtil.format((CharSequence)"Please determine `{}` for update", this.primaryKeyField));
        }
        Entity where = Entity.create(this.tableName).set(this.primaryKeyField, pk);
        Entity record = entity.clone();
        record.remove(this.primaryKeyField);
        return this.runner.update(record, where);
    }

    public int addOrUpdate(Entity entity) throws SQLException {
        return null == entity.get(this.primaryKeyField) ? this.add(entity) : this.update(entity);
    }

    public <T> Entity get(T pk) throws SQLException {
        return this.get(this.primaryKeyField, pk);
    }

    public <T> Entity get(String field, T value) throws SQLException {
        return this.get(Entity.create(this.tableName).set(field, value));
    }

    public Entity get(Entity where) throws SQLException {
        return this.runner.find(null, this.fixEntity(where), new EntityHandler());
    }

    public <T> List<Entity> find(String field, T value) throws SQLException {
        return this.find(Entity.create(this.tableName).set(field, value));
    }

    public List<Entity> findAll() throws SQLException {
        return this.find(Entity.create(this.tableName));
    }

    public List<Entity> find(Entity where) throws SQLException {
        return this.runner.find(null, this.fixEntity(where), new EntityListHandler());
    }

    public List<Entity> findBySql(String sql, Object ... params) throws SQLException {
        String selectKeyword = StrUtil.subPre(sql.trim(), 6).toLowerCase();
        if (!"select".equals(selectKeyword)) {
            sql = "SELECT * FROM " + this.tableName + " " + sql;
        }
        return this.runner.query(sql, new EntityListHandler(), params);
    }

    public PageResult<Entity> page(Entity where, Page page, String ... selectFields) throws SQLException {
        return this.runner.page(Arrays.asList(selectFields), this.fixEntity(where), page);
    }

    public PageResult<Entity> page(Entity where, Page page) throws SQLException {
        return this.runner.page(this.fixEntity(where), page);
    }

    public int count(Entity where) throws SQLException {
        return this.runner.count(this.fixEntity(where));
    }

    public boolean exist(Entity where) throws SQLException {
        return this.count(where) > 0;
    }

    private Entity fixEntity(Entity entity) {
        if (null == entity) {
            entity = Entity.create(this.tableName);
        } else if (StrUtil.isBlank(entity.getTableName())) {
            entity.setTableName(this.tableName);
        }
        return entity;
    }
}

