/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.PageResult;
import com.xiaoleilu.hutool.db.SqlConnRunner;
import com.xiaoleilu.hutool.db.handler.EntityHandler;
import com.xiaoleilu.hutool.db.handler.EntityListHandler;
import com.xiaoleilu.hutool.db.handler.RsHandler;
import com.xiaoleilu.hutool.db.sql.Condition;
import com.xiaoleilu.hutool.db.sql.SqlExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public abstract class AbstractSqlRunner {
    protected SqlConnRunner runner;

    public abstract Connection getConnection() throws SQLException;

    public abstract void closeConnection(Connection var1);

    public <T> T query(String sql, RsHandler<T> rsh, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = SqlExecutor.query(conn, sql, rsh, params);
            return t;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int execute(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = SqlExecutor.execute(conn, sql, params);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public Long executeForGeneratedKey(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            Long l = SqlExecutor.executeForGeneratedKey(conn, sql, params);
            return l;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int[] executeBatch(String sql, Object[] ... paramsBatch) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = SqlExecutor.executeBatch(conn, sql, paramsBatch);
            return nArray;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int insert(Entity record) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.insert(conn, record);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int[] insert(Collection<Entity> records) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = this.runner.insert(conn, records);
            return nArray;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public List<Object> insertForGeneratedKeys(Entity record) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            List<Object> list = this.runner.insertForGeneratedKeys(conn, record);
            return list;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public Long insertForGeneratedKey(Entity record) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            Long l = this.runner.insertForGeneratedKey(conn, record);
            return l;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int del(String tableName, String field, Object value) throws SQLException {
        return this.del(Entity.create(tableName).set(field, value));
    }

    public int del(Entity where) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.del(conn, where);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int update(Entity record, Entity where) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.update(conn, record, where);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> Entity get(String tableName, String field, T value) throws SQLException {
        return this.get(Entity.create(tableName).set(field, value));
    }

    public Entity get(Entity where) throws SQLException {
        return this.find(null, where, new EntityHandler());
    }

    public <T> T find(Collection<String> fields, Entity where, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.find(conn, fields, where, rsh);
            return t;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> T find(Entity where, RsHandler<T> rsh) throws SQLException {
        return this.find(null, where, rsh);
    }

    public List<Entity> findAll(Entity where) throws SQLException {
        return this.find(where, EntityListHandler.create());
    }

    public List<Entity> findAll(String tableName) throws SQLException {
        return this.findAll(Entity.create(tableName));
    }

    public List<Entity> findBy(String tableName, String field, Object value) throws SQLException {
        return this.findAll(Entity.create(tableName).set(field, value));
    }

    public List<Entity> findLike(String tableName, String field, String value, Condition.LikeType likeType) throws SQLException {
        return this.findAll(Entity.create(tableName).set(field, DbUtil.buildLikeValue(value, likeType)));
    }

    public int count(Entity where) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.count(conn, where);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> T page(Collection<String> fields, Entity where, int page, int numPerPage, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.page(conn, fields, where, page, numPerPage, rsh);
            return t;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> T page(Collection<String> fields, Entity where, Page page, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.page(conn, fields, where, page, rsh);
            return t;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public PageResult<Entity> page(Collection<String> fields, Entity where, int page, int numPerPage) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            PageResult<Entity> pageResult = this.runner.page(conn, fields, where, page, numPerPage);
            return pageResult;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public PageResult<Entity> page(Collection<String> fields, Entity where, Page page) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            PageResult<Entity> pageResult = this.runner.page(conn, fields, where, page);
            return pageResult;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public PageResult<Entity> page(Entity where, Page page) throws SQLException {
        return this.page(null, where, page);
    }

    public SqlConnRunner getRunner() {
        return this.runner;
    }

    public void setRunner(SqlConnRunner runner) {
        this.runner = runner;
    }
}

