/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.javadoc;

import com.webcohesion.enunciate.javac.javadoc.JavaDoc;

public class JavaDocLink {
    private final String text;
    private final int classNameStart;
    private final int classNameEnd;
    private final int memberNameStart;
    private final int memberNameEnd;
    private final int labelStart;
    private final int labelEnd;

    private JavaDocLink(String text, int classNameStart, int classNameEnd, int memberNameStart, int memberNameEnd, int labelStart, int labelEnd) {
        this.text = text;
        this.classNameStart = classNameStart;
        this.classNameEnd = classNameEnd;
        this.memberNameStart = memberNameStart;
        this.memberNameEnd = memberNameEnd;
        this.labelStart = labelStart;
        this.labelEnd = labelEnd;
    }

    public String getClassName() {
        return this.text.substring(this.classNameStart, this.classNameEnd);
    }

    public String getMemberName() {
        return this.memberNameStart > 0 ? this.text.substring(this.memberNameStart, this.memberNameEnd) : "";
    }

    public boolean hasLabel() {
        return this.labelStart > 0;
    }

    public String getLabel() {
        return this.labelStart > 0 ? this.text.substring(this.labelStart, this.labelEnd) : null;
    }

    public String toString() {
        return this.text;
    }

    public static JavaDocLink parse(String text) {
        int i;
        int start;
        int length;
        for (length = text.length(); length > 0 && JavaDoc.isWhitespace(text.charAt(length - 1)); --length) {
        }
        for (start = 0; start < length && JavaDoc.isWhitespace(text.charAt(start)); ++start) {
        }
        int fragmentStart = text.indexOf(35, start);
        int memberNameEnd = -1;
        int rightParen = -1;
        if (fragmentStart >= 0 && (memberNameEnd = text.indexOf(40, fragmentStart)) >= 0) {
            rightParen = text.indexOf(41, memberNameEnd);
        }
        int referenceEnd = length;
        int labelStart = -1;
        int n = i = rightParen < 0 ? start : rightParen;
        block2: while (i < length) {
            if (JavaDoc.isWhitespace(text.charAt(i))) {
                referenceEnd = i;
                while (++i < length) {
                    if (JavaDoc.isWhitespace(text.charAt(i))) continue;
                    labelStart = i;
                    break block2;
                }
                break;
            }
            ++i;
        }
        if (memberNameEnd == -1) {
            memberNameEnd = referenceEnd;
        }
        return new JavaDocLink(text, start, fragmentStart >= 0 ? fragmentStart : referenceEnd, fragmentStart >= 0 ? fragmentStart + 1 : -1, memberNameEnd, labelStart, length);
    }
}

