/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMParser;

public class CertificateManager {
    private static final ConcurrentHashMap<String, ServerCertificateInfo> certificateCache = new ConcurrentHashMap();

    private static List<String> getDnsNamesFromExtension(Extension sanExtension) {
        ArrayList<String> dnsNames = new ArrayList<String>();
        try {
            GeneralNames generalNames = GeneralNames.getInstance((Object)sanExtension.getParsedValue());
            for (GeneralName generalName : generalNames.getNames()) {
                if (generalName.getTagNo() != 2) continue;
                String dnsName = generalName.getName().toString();
                dnsNames.add(dnsName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting DNS names from extension:", e);
        }
        return dnsNames;
    }

    public static boolean hasCertificateInCache(String ep) {
        return certificateCache.containsKey(ep);
    }

    public static ServerCertificateInfo getServerCertificateFromCache(String ep) {
        return certificateCache.get(ep);
    }

    public static ServerCertificateInfo getServerCertificate(String apiKey, String baseUrl, String ep) throws IOException {
        if (CertificateManager.hasCertificateInCache(ep)) {
            return CertificateManager.getServerCertificateFromCache(ep);
        }
        try {
            String volcArkEncryption = System.getenv("VOLC_ARK_ENCRYPTION");
            boolean aiccEnabled = "AICC".equals(volcArkEncryption);
            String certificate = CertificateManager.loadCertificateLocally(ep);
            if (certificate != null) {
                return CertificateManager.createCertificateInfo(certificate, ep);
            }
            certificate = CertificateManager.loadCertificateByApiKey(baseUrl, apiKey, ep, aiccEnabled);
            CertificateManager.saveCertificateLocally(ep, certificate);
            return CertificateManager.createCertificateInfo(certificate, ep);
        }
        catch (Exception e) {
            throw new IOException("Failed to fetch server certificate", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getCertInfo(String certPem) {
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(certPem));){
            List<String> dnsNames;
            X509CertificateHolder certHolder;
            Extension sanExtension;
            Object object = pemParser.readObject();
            if (!(object instanceof X509CertificateHolder) || (sanExtension = (certHolder = (X509CertificateHolder)object).getExtension(Extension.subjectAlternativeName)) == null || (dnsNames = CertificateManager.getDnsNamesFromExtension(sanExtension)).size() <= 1) return new String[]{"", ""};
            String firstDns = dnsNames.get(0);
            String secondDns = dnsNames.get(1);
            Pattern ringPattern = Pattern.compile("^ring\\..*$");
            Pattern keyPattern = Pattern.compile("^key\\..*$");
            if (!ringPattern.matcher(firstDns).matches() || !keyPattern.matcher(secondDns).matches()) return new String[]{"", ""};
            String ringId = firstDns.substring(5);
            String keyId = secondDns.substring(4);
            String[] stringArray = new String[]{ringId, keyId};
            return stringArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse certificate to get ring_id and key_id", e);
        }
    }

    public static String loadCertificateLocally(String ep) throws IOException {
        try {
            String certStoragePath = CertificateManager.getCertStoragePath();
            String certFilePath = certStoragePath + File.separator + ep + ".pem";
            File certFile = new File(certFilePath);
            if (certFile.exists()) {
                long certExpirationSeconds;
                long lastModifiedSeconds = certFile.lastModified() / 1000L;
                long currentTimeSeconds = System.currentTimeMillis() / 1000L;
                long timeDifferenceSeconds = currentTimeSeconds - lastModifiedSeconds;
                if (timeDifferenceSeconds <= (certExpirationSeconds = 1209600L)) {
                    String certPem = new String(Files.readAllBytes(certFile.toPath()), StandardCharsets.UTF_8);
                    String[] certInfo = CertificateManager.getCertInfo(certPem);
                    String ringId = certInfo[0];
                    String keyId = certInfo[1];
                    boolean aiccEnabled = "AICC".equals(System.getenv("VOLC_ARK_ENCRYPTION"));
                    if ((ringId.isEmpty() || keyId.isEmpty()) && !aiccEnabled) {
                        return certPem;
                    }
                    if (!ringId.isEmpty() && !keyId.isEmpty() && aiccEnabled) {
                        return certPem;
                    }
                }
                certFile.delete();
            }
        }
        catch (Exception e) {
            String errMsg = "Failed to load local certificate: " + e.getMessage();
            throw new IOException(errMsg, e);
        }
        return null;
    }

    public static String loadCertificateByApiKey(String baseUrl, String apiKey, String ep, boolean aiccEnabled) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = CertificateManager.createHttpConnection(baseUrl, apiKey);
            CertificateManager.sendCertificateRequest(connection, ep, aiccEnabled);
            String string = CertificateManager.processCertificateResponse(connection);
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            String errMsg = "\u901a\u8fc7API Key\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25: " + e.getMessage();
            throw new IOException(errMsg, e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static HttpURLConnection createHttpConnection(String baseUrl, String apiKey) throws IOException {
        String certificateUrl = CertificateManager.buildCertificateUrl(baseUrl);
        URL url = URI.create(certificateUrl).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Authorization", "Bearer " + apiKey);
        connection.setRequestProperty("X-Session-Token", "/e2e/get/certificate");
        return connection;
    }

    private static String buildCertificateUrl(String baseUrl) {
        String requestedUrl = baseUrl.replaceAll("/+$", "");
        if (requestedUrl.endsWith("/api/v3")) {
            return requestedUrl + "/e2e/get/certificate";
        }
        return requestedUrl + "/api/v3/e2e/get/certificate";
    }

    private static void sendCertificateRequest(HttpURLConnection connection, String ep, boolean aiccEnabled) throws IOException {
        String jsonBody = CertificateManager.buildRequestBody(ep, aiccEnabled);
        connection.setDoOutput(true);
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = jsonBody.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
    }

    private static String buildRequestBody(String ep, boolean aiccEnabled) throws IOException {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("model", ep);
        if (aiccEnabled) {
            requestBody.put("type", "AICCv0.1");
        }
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(requestBody);
    }

    private static String processCertificateResponse(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (!CertificateManager.isSuccessfulResponse(responseCode)) {
            CertificateManager.handleErrorResponse(connection, responseCode);
        }
        return CertificateManager.extractCertificateFromResponse(connection);
    }

    private static boolean isSuccessfulResponse(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    private static void handleErrorResponse(HttpURLConnection connection, int responseCode) throws IOException {
        String errorResponse = CertificateManager.readErrorResponse(connection);
        String errorMsg = "\u8bc1\u4e66\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801: " + responseCode + ", \u54cd\u5e94: " + errorResponse;
        throw new IOException(errorMsg);
    }

    private static String extractCertificateFromResponse(HttpURLConnection connection) throws IOException {
        String responseBody = CertificateManager.readResponseBody(connection);
        ObjectMapper mapper = new ObjectMapper();
        Map responseJson = (Map)mapper.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        CertificateManager.validateResponse(responseJson);
        if (responseJson.containsKey("Certificate")) {
            return (String)responseJson.get("Certificate");
        }
        throw new IOException("\u54cd\u5e94\u4e2d\u672a\u627e\u5230Certificate\u5b57\u6bb5");
    }

    private static void validateResponse(Map<String, Object> responseJson) throws IOException {
        if (responseJson.containsKey("error")) {
            Object error = responseJson.get("error");
            String errorMsg = "\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25: " + error;
            throw new IOException(errorMsg);
        }
    }

    public static void saveCertificateLocally(String ep, String certificate) throws IOException {
        try {
            String certStoragePath = CertificateManager.getCertStoragePath();
            String certFilePath = certStoragePath + File.separator + ep + ".pem";
            File storageDir = new File(certStoragePath);
            if (!storageDir.exists() && !storageDir.mkdirs()) {
                String errMsg = "\u521b\u5efa\u8bc1\u4e66\u5b58\u50a8\u76ee\u5f55\u5931\u8d25: " + certStoragePath;
                throw new IOException(errMsg);
            }
            Files.write(Paths.get(certFilePath, new String[0]), certificate.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            String errMsg = "\u4fdd\u5b58\u8bc1\u4e66\u5230\u672c\u5730\u5931\u8d25: " + e.getMessage();
            throw new IOException(errMsg, e);
        }
    }

    public static String getCertStoragePath() {
        String userHome = System.getProperty("user.home");
        return userHome + File.separator + ".ark" + File.separator + "certificates";
    }

    public static void cacheServerCertificate(String cacheKey, PublicKey publicKey, String ringId, String keyId) {
        certificateCache.put(cacheKey, new ServerCertificateInfo(publicKey, ringId, keyId));
    }

    public static PublicKey extractPublicKeyFromCertificate(String certificate) throws GeneralSecurityException {
        try {
            String certContent = certificate.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replaceAll("\\s", "");
            byte[] certBytes = Base64.getDecoder().decode(certContent);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBytes));
            return x509Cert.getPublicKey();
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Failed to extract public key from certificate", e);
        }
    }

    public static ServerCertificateInfo createCertificateInfo(String certificate, String ep) throws IOException {
        try {
            String[] result = CertificateManager.getCertInfo(certificate);
            String ringId = result[0];
            String keyId = result[1];
            PublicKey publicKey = CertificateManager.extractPublicKeyFromCertificate(certificate);
            ServerCertificateInfo certInfo = new ServerCertificateInfo(publicKey, ringId, keyId);
            CertificateManager.cacheServerCertificate(ep, publicKey, ringId, keyId);
            return certInfo;
        }
        catch (GeneralSecurityException e) {
            String errMsg = "Failed to extract public key from certificate: " + e.getMessage();
            throw new IOException(errMsg, e);
        }
        catch (Exception e) {
            String errMsg = "Failed to create certificate info: " + e.getMessage();
            throw new IOException(errMsg, e);
        }
    }

    public static String readResponseBody(HttpURLConnection connection) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
    }

    public static String readErrorResponse(HttpURLConnection connection) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder errorResponse = new StringBuilder();
            while ((line = br.readLine()) != null) {
                errorResponse.append(line);
            }
            String string = errorResponse.toString();
            return string;
        }
    }

    public static class ServerCertificateInfo {
        private final PublicKey publicKey;
        private final String ringId;
        private final String keyId;

        public ServerCertificateInfo(PublicKey publicKey, String ringId, String keyId) {
            this.publicKey = publicKey;
            this.ringId = ringId;
            this.keyId = keyId;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        public String getRingId() {
            return this.ringId;
        }

        public String getKeyId() {
            return this.keyId;
        }
    }
}

