/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.files;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.volcengine.ark.runtime.model.files.PreprocessConfigs;
import java.io.File;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UploadFileRequest {
    @JsonProperty(value="file")
    private File file;
    @JsonProperty(value="purpose")
    private String purpose;
    @JsonProperty(value="expire_at")
    private Integer expireAt;
    @JsonProperty(value="preprocess_configs")
    private PreprocessConfigs preprocessConfigs;

    public String toString() {
        return "UploadFileRequest{file=" + this.file + ", purpose='" + this.purpose + '\'' + ", expireAt=" + this.expireAt + ", preprocessConfigs=" + this.preprocessConfigs + '}';
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public Integer getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(Integer expireAt) {
        this.expireAt = expireAt;
    }

    public PreprocessConfigs getPreprocessConfigs() {
        return this.preprocessConfigs;
    }

    public void setPreprocessConfigs(PreprocessConfigs preprocessConfigs) {
        this.preprocessConfigs = preprocessConfigs;
    }

    public static UploadFileRequestBuilder builder() {
        return new UploadFileRequestBuilder();
    }

    public static final class UploadFileRequestBuilder {
        private File file;
        private String purpose;
        private Integer expireAt;
        private PreprocessConfigs preprocessConfigs;

        private UploadFileRequestBuilder() {
        }

        public static UploadFileRequestBuilder anUploadFileRequest() {
            return new UploadFileRequestBuilder();
        }

        public UploadFileRequestBuilder file(File file) {
            this.file = file;
            return this;
        }

        public UploadFileRequestBuilder purpose(String purpose) {
            this.purpose = purpose;
            return this;
        }

        public UploadFileRequestBuilder expireAt(Integer expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        public UploadFileRequestBuilder preprocessConfigs(PreprocessConfigs preprocessConfigs) {
            this.preprocessConfigs = preprocessConfigs;
            return this;
        }

        public UploadFileRequest build() {
            UploadFileRequest uploadFileRequest = new UploadFileRequest();
            uploadFileRequest.setFile(this.file);
            uploadFileRequest.setPurpose(this.purpose);
            uploadFileRequest.setExpireAt(this.expireAt);
            uploadFileRequest.setPreprocessConfigs(this.preprocessConfigs);
            return uploadFileRequest;
        }
    }
}

