/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.responses.item;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.volcengine.ark.runtime.model.responses.item.BaseMessageItem;
import com.volcengine.ark.runtime.model.responses.item.InputItem;
import com.volcengine.ark.runtime.model.responses.item.MessageContent;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ItemEasyMessage
extends BaseMessageItem
implements InputItem {
    @JsonProperty(value="content")
    private MessageContent content;

    public MessageContent getContent() {
        return this.content;
    }

    public void setContent(MessageContent content) {
        this.content = content;
    }

    public String toString() {
        return "ItemEasyMessage{type='" + this.getType() + '\'' + ", role='" + this.getRole() + '\'' + ", content=" + this.content + ", id='" + this.getId() + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String role;
        private MessageContent content;
        private String id;

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public Builder content(MessageContent content) {
            this.content = content;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public ItemEasyMessage build() {
            ItemEasyMessage itemEasyMessage = new ItemEasyMessage();
            itemEasyMessage.setRole(this.role);
            itemEasyMessage.setContent(this.content);
            itemEasyMessage.setId(this.id);
            return itemEasyMessage;
        }
    }
}

