/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.responses.item;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.volcengine.ark.runtime.model.responses.content.OutputContentItem;
import com.volcengine.ark.runtime.model.responses.item.BaseMessageItem;
import com.volcengine.ark.runtime.model.responses.item.OutputItem;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ItemOutputMessage
extends BaseMessageItem
implements OutputItem {
    @JsonProperty(value="content")
    private List<OutputContentItem> content;
    @JsonProperty(value="status")
    private String status;

    public List<OutputContentItem> getContent() {
        return this.content;
    }

    public void setContent(List<OutputContentItem> content) {
        this.content = content;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        return "ItemOutputMessage{type='" + this.getType() + '\'' + ", role='" + this.getRole() + '\'' + ", content=" + this.content + ", status='" + this.status + '\'' + ", id='" + this.getId() + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String role;
        private List<OutputContentItem> content;
        private String status;
        private String id;

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public Builder content(List<OutputContentItem> content) {
            this.content = content;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public ItemOutputMessage build() {
            ItemOutputMessage itemOutputMessage = new ItemOutputMessage();
            itemOutputMessage.setRole(this.role);
            itemOutputMessage.setContent(this.content);
            itemOutputMessage.setStatus(this.status);
            itemOutputMessage.setId(this.id);
            return itemOutputMessage;
        }
    }
}

