/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.completion.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.volcengine.ark.runtime.utils.JacksonUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ChatFunction {
    String name;
    String description;
    @JsonProperty(value="parameters")
    JsonNode parameters;

    public <T> T getParameters(Class<T> cls) {
        return JacksonUtil.jsonNodeToCls(this.parameters, cls);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JsonNode getParameters() {
        return this.parameters;
    }

    public void setParameters(JsonNode parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        return "ChatFunction{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", parameters=" + this.parameters + '}';
    }

    public static class Builder {
        private String name;
        private String description;
        private JsonNode parameters;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parameters(Object parameters) {
            this.parameters = JacksonUtil.clsToJsonNode(parameters);
            return this;
        }

        public ChatFunction build() {
            ChatFunction chatFunction = new ChatFunction();
            chatFunction.setName(this.name);
            chatFunction.setDescription(this.description);
            chatFunction.setParameters(this.parameters);
            return chatFunction;
        }
    }
}

