/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.imp.impl;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.response.RawResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.imp.IImpService;
import com.volcengine.service.imp.ImpServiceConfig;
import com.volcengine.service.imp.model.request.ImpKillJobRequest;
import com.volcengine.service.imp.model.request.ImpRetrieveJobRequest;
import com.volcengine.service.imp.model.request.ImpSubmitJobRequest;
import com.volcengine.service.imp.model.response.ImpKillJobResponse;
import com.volcengine.service.imp.model.response.ImpRetrieveJobResponse;
import com.volcengine.service.imp.model.response.ImpSubmitJobResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ImpServiceImpl
extends BaseServiceImpl
implements IImpService {
    private static final ImpServiceImpl CN_NORTH_1_SERVICE = new ImpServiceImpl();

    public static IImpService getInstance() {
        return CN_NORTH_1_SERVICE;
    }

    protected ImpServiceImpl() {
        super(ImpServiceConfig.ServiceInfoMap.get("cn-north-1"), ImpServiceConfig.apiInfoList);
    }

    public static IImpService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = ImpServiceConfig.ServiceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Cant find the region, please check it carefully");
        }
        switch (region) {
            case "cn-north-1": {
                return CN_NORTH_1_SERVICE;
            }
        }
        throw new Exception("Cant find the region, please check it carefully");
    }

    @Override
    public ImpSubmitJobResponse SubmitJob(ImpSubmitJobRequest input) throws Exception {
        RawResponse response = this.query("SubmitJob", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ImpSubmitJobResponse.Builder responseBuilder = ImpSubmitJobResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public ImpKillJobResponse KillJob(ImpKillJobRequest input) throws Exception {
        RawResponse response = this.query("KillJob", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ImpKillJobResponse.Builder responseBuilder = ImpKillJobResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public ImpRetrieveJobResponse RetrieveJob(ImpRetrieveJobRequest input) throws Exception {
        RawResponse response = this.query("RetrieveJob", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ImpRetrieveJobResponse.Builder responseBuilder = ImpRetrieveJobResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }
}

