/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jtsexample.geom.ExtendedCoordinate;

public class ExtendedCoordinateSequence
implements CoordinateSequence {
    private ExtendedCoordinate[] coordinates;

    public static ExtendedCoordinate[] copy(Coordinate[] coordinates) {
        ExtendedCoordinate[] copy = new ExtendedCoordinate[coordinates.length];
        int i = 0;
        while (i < coordinates.length) {
            copy[i] = new ExtendedCoordinate(coordinates[i]);
            ++i;
        }
        return copy;
    }

    public static ExtendedCoordinate[] copy(CoordinateSequence coordSeq) {
        ExtendedCoordinate[] copy = new ExtendedCoordinate[coordSeq.size()];
        int i = 0;
        while (i < coordSeq.size()) {
            copy[i] = new ExtendedCoordinate(coordSeq.getCoordinate(i));
            ++i;
        }
        return copy;
    }

    public ExtendedCoordinateSequence(ExtendedCoordinate[] coordinates) {
        this.coordinates = coordinates;
    }

    public ExtendedCoordinateSequence(Coordinate[] copyCoords) {
        this.coordinates = ExtendedCoordinateSequence.copy(copyCoords);
    }

    public ExtendedCoordinateSequence(CoordinateSequence coordSeq) {
        this.coordinates = ExtendedCoordinateSequence.copy(coordSeq);
    }

    public ExtendedCoordinateSequence(int size) {
        this.coordinates = new ExtendedCoordinate[size];
        int i = 0;
        while (i < size) {
            this.coordinates[i] = new ExtendedCoordinate();
            ++i;
        }
    }

    public int getDimension() {
        return 4;
    }

    public Coordinate getCoordinate(int i) {
        return this.coordinates[i];
    }

    public Coordinate getCoordinateCopy(int index) {
        return new Coordinate((Coordinate)this.coordinates[index]);
    }

    public void getCoordinate(int index, Coordinate coord) {
        coord.x = this.coordinates[index].x;
        coord.y = this.coordinates[index].y;
    }

    public double getX(int index) {
        return this.coordinates[index].x;
    }

    public double getY(int index) {
        return this.coordinates[index].y;
    }

    public double getOrdinate(int index, int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.coordinates[index].x;
            }
            case 1: {
                return this.coordinates[index].y;
            }
            case 2: {
                return this.coordinates[index].z;
            }
            case 3: {
                return this.coordinates[index].getM();
            }
        }
        return Double.NaN;
    }

    public void setOrdinate(int index, int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.coordinates[index].x = value;
                break;
            }
            case 1: {
                this.coordinates[index].y = value;
                break;
            }
            case 2: {
                this.coordinates[index].z = value;
                break;
            }
            case 3: {
                this.coordinates[index].setM(value);
            }
        }
    }

    public Object clone() {
        ExtendedCoordinate[] cloneCoordinates = new ExtendedCoordinate[this.size()];
        int i = 0;
        while (i < this.coordinates.length) {
            cloneCoordinates[i] = (ExtendedCoordinate)((Object)this.coordinates[i].clone());
            ++i;
        }
        return new ExtendedCoordinateSequence(cloneCoordinates);
    }

    public int size() {
        return this.coordinates.length;
    }

    public Coordinate[] toCoordinateArray() {
        return this.coordinates;
    }

    public Envelope expandEnvelope(Envelope env) {
        int i = 0;
        while (i < this.coordinates.length) {
            env.expandToInclude((Coordinate)this.coordinates[i]);
            ++i;
        }
        return env;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("ExtendedCoordinateSequence [");
        int i = 0;
        while (i < this.coordinates.length) {
            if (i > 0) {
                strBuf.append(", ");
            }
            strBuf.append((Object)this.coordinates[i]);
            ++i;
        }
        strBuf.append("]");
        return strBuf.toString();
    }
}

