/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.OptionsParser;

public final class JSONOptions {
    public static final JSONOptions Default = new JSONOptions();
    private final boolean propVarbase64padding;
    private final boolean propVarpreservenegativezero;
    private final ConversionMode propVarnumberconversion;
    private final boolean propVarallowduplicatekeys;
    private final boolean propVarreplacesurrogates;

    public JSONOptions() {
        this("");
    }

    @Deprecated
    public JSONOptions(boolean base64Padding) {
        this("base64Padding=" + (base64Padding ? "1" : "0"));
    }

    @Deprecated
    public JSONOptions(boolean base64Padding, boolean replaceSurrogates) {
        this("base64Padding=" + (base64Padding ? "1" : "0") + ";replacesurrogates=" + (replaceSurrogates ? "1" : "0"));
    }

    public JSONOptions(String paramString) {
        if (paramString == null) {
            throw new NullPointerException("paramString");
        }
        OptionsParser parser = new OptionsParser(paramString);
        this.propVarpreservenegativezero = parser.GetBoolean("preservenegativezero", true);
        this.propVarallowduplicatekeys = parser.GetBoolean("allowduplicatekeys", false);
        this.propVarbase64padding = parser.GetBoolean("base64padding", true);
        this.propVarreplacesurrogates = parser.GetBoolean("replacesurrogates", false);
        this.propVarnumberconversion = JSONOptions.ToNumberConversion(parser.GetLCString("numberconversion", null));
    }

    public String toString() {
        return "base64padding=" + (this.getBase64Padding() ? "true" : "false") + ";replacesurrogates=" + (this.getReplaceSurrogates() ? "true" : "false") + (this.getPreserveNegativeZero() ? "true" : "false") + ";numberconversion=" + this.FromNumberConversion() + ";allowduplicatekeys=" + (this.getAllowDuplicateKeys() ? "true" : "false");
    }

    @Deprecated
    public final boolean getBase64Padding() {
        return this.propVarbase64padding;
    }

    private String FromNumberConversion() {
        ConversionMode kind = this.getNumberConversion();
        if (kind == ConversionMode.Full) {
            return "full";
        }
        if (kind == ConversionMode.Double) {
            return "double";
        }
        if (kind == ConversionMode.Decimal128) {
            return "decimal128";
        }
        if (kind == ConversionMode.IntOrFloat) {
            return "intorfloat";
        }
        return kind == ConversionMode.IntOrFloatFromDouble ? "intorfloatfromdouble" : "full";
    }

    private static ConversionMode ToNumberConversion(String str) {
        if (str != null) {
            if (str.equals("full")) {
                return ConversionMode.Full;
            }
            if (str.equals("double")) {
                return ConversionMode.Double;
            }
            if (str.equals("decimal128")) {
                return ConversionMode.Decimal128;
            }
            if (str.equals("intorfloat")) {
                return ConversionMode.IntOrFloat;
            }
            if (str.equals("intorfloatfromdouble")) {
                return ConversionMode.IntOrFloatFromDouble;
            }
        } else {
            return ConversionMode.Full;
        }
        throw new IllegalArgumentException("Unrecognized conversion mode");
    }

    public final boolean getPreserveNegativeZero() {
        return this.propVarpreservenegativezero;
    }

    public final ConversionMode getNumberConversion() {
        return this.propVarnumberconversion;
    }

    public final boolean getAllowDuplicateKeys() {
        return this.propVarallowduplicatekeys;
    }

    public final boolean getReplaceSurrogates() {
        return this.propVarreplacesurrogates;
    }

    public static enum ConversionMode {
        Full,
        Double,
        IntOrFloat,
        IntOrFloatFromDouble,
        Decimal128;

    }
}

