/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum CollectSupportDataSecurityLevel {
    NONE("none"),
    OBSCURE_SECRETS("obscure-secrets"),
    MAXIMUM("maximum");

    private final String name;

    private CollectSupportDataSecurityLevel(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static CollectSupportDataSecurityLevel forName(String name) {
        String normalizedName = StaticUtils.toLowerCase(name).replace('_', '-');
        for (CollectSupportDataSecurityLevel l : CollectSupportDataSecurityLevel.values()) {
            if (!normalizedName.equals(l.name)) continue;
            return l;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

