/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionInfo;
import com.unboundid.ldap.sdk.LDAPConnectionLogger;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class SASLBindRequest
extends BindRequest
implements ResponseAcceptor {
    protected static final byte CRED_TYPE_SASL = -93;
    private static final long serialVersionUID = -5842126553864908312L;
    private int messageID = -1;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();

    protected SASLBindRequest(Control[] controls) {
        super(controls);
    }

    @Override
    public String getBindType() {
        return this.getSASLMechanismName();
    }

    public abstract String getSASLMechanismName();

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    protected final BindResult sendBindRequest(LDAPConnection connection, String bindDN, ASN1OctetString saslCredentials, Control[] controls, long timeoutMillis) throws LDAPException {
        this.messageID = connection.nextMessageID();
        BindRequestProtocolOp protocolOp = new BindRequestProtocolOp(bindDN, this.getSASLMechanismName(), saslCredentials);
        LDAPMessage requestMessage = new LDAPMessage(this.messageID, (ProtocolOp)protocolOp, controls);
        return this.sendMessage(connection, requestMessage, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BindResult sendMessage(LDAPConnection connection, LDAPMessage requestMessage, long timeoutMillis) throws LDAPException {
        if (connection.synchronousMode()) {
            return this.sendMessageSync(connection, requestMessage, timeoutMillis);
        }
        int msgID = requestMessage.getMessageID();
        connection.registerResponseAcceptor(msgID, this);
        try {
            LDAPResponse response;
            Debug.debugLDAPRequest(Level.INFO, this, msgID, connection);
            LDAPConnectionLogger logger = connection.getConnectionOptions().getConnectionLogger();
            if (logger != null) {
                logger.logBindRequest((LDAPConnectionInfo)connection, this.messageID, this);
            }
            long requestTime = System.nanoTime();
            connection.getConnectionStatistics().incrementNumBindRequests();
            connection.sendMessage(requestMessage, timeoutMillis);
            try {
                response = timeoutMillis > 0L ? this.responseQueue.poll(timeoutMillis, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_BIND_INTERRUPTED.get(connection.getHostPort()), ie);
            }
            BindResult bindResult = this.handleResponse(connection, response, requestTime);
            return bindResult;
        }
        finally {
            connection.deregisterResponseAcceptor(msgID);
        }
    }

    private BindResult sendMessageSync(LDAPConnection connection, LDAPMessage requestMessage, long timeoutMillis) throws LDAPException {
        LDAPResponse response;
        int msgID = requestMessage.getMessageID();
        Debug.debugLDAPRequest(Level.INFO, this, msgID, connection);
        LDAPConnectionLogger logger = connection.getConnectionOptions().getConnectionLogger();
        if (logger != null) {
            logger.logBindRequest((LDAPConnectionInfo)connection, this.messageID, this);
        }
        long requestTime = System.nanoTime();
        connection.getConnectionStatistics().incrementNumBindRequests();
        connection.sendMessage(requestMessage, timeoutMillis);
        while ((response = connection.readResponse(this.messageID)) instanceof IntermediateResponse) {
            IntermediateResponseListener listener = this.getIntermediateResponseListener();
            if (listener == null) continue;
            listener.intermediateResponseReturned((IntermediateResponse)response);
        }
        return this.handleResponse(connection, response, requestTime);
    }

    private BindResult handleResponse(LDAPConnection connection, LDAPResponse response, long requestTime) throws LDAPException {
        if (response == null) {
            long waitTime = StaticUtils.nanosToMillis(System.nanoTime() - requestTime);
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_SASL_BIND_CLIENT_TIMEOUT.get(waitTime, this.getSASLMechanismName(), this.messageID, connection.getHostPort()));
        }
        if (response instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE.get(connection.getHostPort(), this.toString()));
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), message));
        }
        connection.getConnectionStatistics().incrementNumBindResponses(System.nanoTime() - requestTime);
        return (BindResult)response;
    }

    @Override
    @InternalUseOnly
    public final void responseReceived(LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public void toCode(List<String> lineList, String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(4);
        constructorArgs.add(ToCodeArgHelper.createString(null, "Bind DN"));
        constructorArgs.add(ToCodeArgHelper.createString(this.getSASLMechanismName(), "SASL Mechanism Name"));
        constructorArgs.add(ToCodeArgHelper.createByteArray("---redacted-SASL-credentials".getBytes(StandardCharsets.UTF_8), true, "SASL Credentials"));
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "GenericSASLBindRequest", requestID + "Request", "new GenericSASLBindRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + '{');
            lineList.add(indent + "  BindResult " + requestID + "Result = connection.bind(" + requestID + "Request);");
            lineList.add(indent + "  // The bind was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (SASLBindInProgressException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The SASL bind requires multiple stages.  " + "Continue it here.");
            lineList.add(indent + "  // Do not attempt to use the connection for " + "any other purpose until bind processing has completed.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The bind failed.  Maybe the following will " + "help explain why.");
            lineList.add(indent + "  // Note that the connection is now likely in " + "an unauthenticated state.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = " + "e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

