/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum AlertSeverity {
    INFO("info"),
    WARNING("warning"),
    ERROR("error"),
    FATAL("fatal");

    private final String name;

    private AlertSeverity(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static AlertSeverity forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "info": {
                return INFO;
            }
            case "warning": {
                return WARNING;
            }
            case "error": {
                return ERROR;
            }
            case "fatal": {
                return FATAL;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

