/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tat.v20201028.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeRegisterCodesResponse extends AbstractModel {

    /**
    * 查询到的注册码总数。
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * 注册码信息列表。
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("RegisterCodeSet")
    @Expose
    private RegisterCodeInfo [] RegisterCodeSet;

    /**
    * 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 查询到的注册码总数。 
     * @return TotalCount 查询到的注册码总数。
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set 查询到的注册码总数。
     * @param TotalCount 查询到的注册码总数。
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get 注册码信息列表。
注意：此字段可能返回 null，表示取不到有效值。 
     * @return RegisterCodeSet 注册码信息列表。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public RegisterCodeInfo [] getRegisterCodeSet() {
        return this.RegisterCodeSet;
    }

    /**
     * Set 注册码信息列表。
注意：此字段可能返回 null，表示取不到有效值。
     * @param RegisterCodeSet 注册码信息列表。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setRegisterCodeSet(RegisterCodeInfo [] RegisterCodeSet) {
        this.RegisterCodeSet = RegisterCodeSet;
    }

    /**
     * Get 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeRegisterCodesResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeRegisterCodesResponse(DescribeRegisterCodesResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.RegisterCodeSet != null) {
            this.RegisterCodeSet = new RegisterCodeInfo[source.RegisterCodeSet.length];
            for (int i = 0; i < source.RegisterCodeSet.length; i++) {
                this.RegisterCodeSet[i] = new RegisterCodeInfo(source.RegisterCodeSet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "RegisterCodeSet.", this.RegisterCodeSet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

