/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.mrs.v20200910.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class TimelineInformation extends AbstractModel {

    /**
    * 时间轴
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Timeline")
    @Expose
    private TimelineEvent [] Timeline;

    /**
    * 数据在原PDF文件中的第几页
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Page")
    @Expose
    private Long Page;

    /**
     * Get 时间轴
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Timeline 时间轴
注意：此字段可能返回 null，表示取不到有效值。
     */
    public TimelineEvent [] getTimeline() {
        return this.Timeline;
    }

    /**
     * Set 时间轴
注意：此字段可能返回 null，表示取不到有效值。
     * @param Timeline 时间轴
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setTimeline(TimelineEvent [] Timeline) {
        this.Timeline = Timeline;
    }

    /**
     * Get 数据在原PDF文件中的第几页
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Page 数据在原PDF文件中的第几页
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getPage() {
        return this.Page;
    }

    /**
     * Set 数据在原PDF文件中的第几页
注意：此字段可能返回 null，表示取不到有效值。
     * @param Page 数据在原PDF文件中的第几页
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setPage(Long Page) {
        this.Page = Page;
    }

    public TimelineInformation() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public TimelineInformation(TimelineInformation source) {
        if (source.Timeline != null) {
            this.Timeline = new TimelineEvent[source.Timeline.length];
            for (int i = 0; i < source.Timeline.length; i++) {
                this.Timeline[i] = new TimelineEvent(source.Timeline[i]);
            }
        }
        if (source.Page != null) {
            this.Page = new Long(source.Page);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Timeline.", this.Timeline);
        this.setParamSimple(map, prefix + "Page", this.Page);

    }
}

