/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.monitor.v20180724.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreatePrometheusMultiTenantInstancePostPayModeRequest extends AbstractModel {

    /**
    * 实例名
    */
    @SerializedName("InstanceName")
    @Expose
    private String InstanceName;

    /**
    * VPC ID(可通过 vpc:DescribeVpcs 接口获取，与实例同地域)
    */
    @SerializedName("VpcId")
    @Expose
    private String VpcId;

    /**
    * 子网 ID(可通过 vpc:DescribeSubnets 接口获取)
    */
    @SerializedName("SubnetId")
    @Expose
    private String SubnetId;

    /**
    * 数据存储时间（单位天），限制值为15, 30, 45, 90, 180, 365, 730之一
    */
    @SerializedName("DataRetentionTime")
    @Expose
    private Long DataRetentionTime;

    /**
    * 可用区(与子网同可用区)
    */
    @SerializedName("Zone")
    @Expose
    private String Zone;

    /**
    * 实例的标签
    */
    @SerializedName("TagSpecification")
    @Expose
    private PrometheusTag [] TagSpecification;

    /**
    * 需要关联的 Grafana 实例
    */
    @SerializedName("GrafanaInstanceId")
    @Expose
    private String GrafanaInstanceId;

    /**
     * Get 实例名 
     * @return InstanceName 实例名
     */
    public String getInstanceName() {
        return this.InstanceName;
    }

    /**
     * Set 实例名
     * @param InstanceName 实例名
     */
    public void setInstanceName(String InstanceName) {
        this.InstanceName = InstanceName;
    }

    /**
     * Get VPC ID(可通过 vpc:DescribeVpcs 接口获取，与实例同地域) 
     * @return VpcId VPC ID(可通过 vpc:DescribeVpcs 接口获取，与实例同地域)
     */
    public String getVpcId() {
        return this.VpcId;
    }

    /**
     * Set VPC ID(可通过 vpc:DescribeVpcs 接口获取，与实例同地域)
     * @param VpcId VPC ID(可通过 vpc:DescribeVpcs 接口获取，与实例同地域)
     */
    public void setVpcId(String VpcId) {
        this.VpcId = VpcId;
    }

    /**
     * Get 子网 ID(可通过 vpc:DescribeSubnets 接口获取) 
     * @return SubnetId 子网 ID(可通过 vpc:DescribeSubnets 接口获取)
     */
    public String getSubnetId() {
        return this.SubnetId;
    }

    /**
     * Set 子网 ID(可通过 vpc:DescribeSubnets 接口获取)
     * @param SubnetId 子网 ID(可通过 vpc:DescribeSubnets 接口获取)
     */
    public void setSubnetId(String SubnetId) {
        this.SubnetId = SubnetId;
    }

    /**
     * Get 数据存储时间（单位天），限制值为15, 30, 45, 90, 180, 365, 730之一 
     * @return DataRetentionTime 数据存储时间（单位天），限制值为15, 30, 45, 90, 180, 365, 730之一
     */
    public Long getDataRetentionTime() {
        return this.DataRetentionTime;
    }

    /**
     * Set 数据存储时间（单位天），限制值为15, 30, 45, 90, 180, 365, 730之一
     * @param DataRetentionTime 数据存储时间（单位天），限制值为15, 30, 45, 90, 180, 365, 730之一
     */
    public void setDataRetentionTime(Long DataRetentionTime) {
        this.DataRetentionTime = DataRetentionTime;
    }

    /**
     * Get 可用区(与子网同可用区) 
     * @return Zone 可用区(与子网同可用区)
     */
    public String getZone() {
        return this.Zone;
    }

    /**
     * Set 可用区(与子网同可用区)
     * @param Zone 可用区(与子网同可用区)
     */
    public void setZone(String Zone) {
        this.Zone = Zone;
    }

    /**
     * Get 实例的标签 
     * @return TagSpecification 实例的标签
     */
    public PrometheusTag [] getTagSpecification() {
        return this.TagSpecification;
    }

    /**
     * Set 实例的标签
     * @param TagSpecification 实例的标签
     */
    public void setTagSpecification(PrometheusTag [] TagSpecification) {
        this.TagSpecification = TagSpecification;
    }

    /**
     * Get 需要关联的 Grafana 实例 
     * @return GrafanaInstanceId 需要关联的 Grafana 实例
     */
    public String getGrafanaInstanceId() {
        return this.GrafanaInstanceId;
    }

    /**
     * Set 需要关联的 Grafana 实例
     * @param GrafanaInstanceId 需要关联的 Grafana 实例
     */
    public void setGrafanaInstanceId(String GrafanaInstanceId) {
        this.GrafanaInstanceId = GrafanaInstanceId;
    }

    public CreatePrometheusMultiTenantInstancePostPayModeRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreatePrometheusMultiTenantInstancePostPayModeRequest(CreatePrometheusMultiTenantInstancePostPayModeRequest source) {
        if (source.InstanceName != null) {
            this.InstanceName = new String(source.InstanceName);
        }
        if (source.VpcId != null) {
            this.VpcId = new String(source.VpcId);
        }
        if (source.SubnetId != null) {
            this.SubnetId = new String(source.SubnetId);
        }
        if (source.DataRetentionTime != null) {
            this.DataRetentionTime = new Long(source.DataRetentionTime);
        }
        if (source.Zone != null) {
            this.Zone = new String(source.Zone);
        }
        if (source.TagSpecification != null) {
            this.TagSpecification = new PrometheusTag[source.TagSpecification.length];
            for (int i = 0; i < source.TagSpecification.length; i++) {
                this.TagSpecification[i] = new PrometheusTag(source.TagSpecification[i]);
            }
        }
        if (source.GrafanaInstanceId != null) {
            this.GrafanaInstanceId = new String(source.GrafanaInstanceId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "InstanceName", this.InstanceName);
        this.setParamSimple(map, prefix + "VpcId", this.VpcId);
        this.setParamSimple(map, prefix + "SubnetId", this.SubnetId);
        this.setParamSimple(map, prefix + "DataRetentionTime", this.DataRetentionTime);
        this.setParamSimple(map, prefix + "Zone", this.Zone);
        this.setParamArrayObj(map, prefix + "TagSpecification.", this.TagSpecification);
        this.setParamSimple(map, prefix + "GrafanaInstanceId", this.GrafanaInstanceId);

    }
}

