/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.dlc.v20210125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GroupInfo extends AbstractModel {

    /**
    * 用户组ID
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("WorkGroupId")
    @Expose
    private Long WorkGroupId;

    /**
    * 策略类型
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("StrategyType")
    @Expose
    private String StrategyType;

    /**
     * Get 用户组ID
注意：此字段可能返回 null，表示取不到有效值。 
     * @return WorkGroupId 用户组ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getWorkGroupId() {
        return this.WorkGroupId;
    }

    /**
     * Set 用户组ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param WorkGroupId 用户组ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setWorkGroupId(Long WorkGroupId) {
        this.WorkGroupId = WorkGroupId;
    }

    /**
     * Get 策略类型
注意：此字段可能返回 null，表示取不到有效值。 
     * @return StrategyType 策略类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getStrategyType() {
        return this.StrategyType;
    }

    /**
     * Set 策略类型
注意：此字段可能返回 null，表示取不到有效值。
     * @param StrategyType 策略类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setStrategyType(String StrategyType) {
        this.StrategyType = StrategyType;
    }

    public GroupInfo() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GroupInfo(GroupInfo source) {
        if (source.WorkGroupId != null) {
            this.WorkGroupId = new Long(source.WorkGroupId);
        }
        if (source.StrategyType != null) {
            this.StrategyType = new String(source.StrategyType);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "WorkGroupId", this.WorkGroupId);
        this.setParamSimple(map, prefix + "StrategyType", this.StrategyType);

    }
}

