/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class MalwareRiskOverview extends AbstractModel {

    /**
    * 影响主机数
    */
    @SerializedName("HostCount")
    @Expose
    private Long HostCount;

    /**
    * 异常进程数
    */
    @SerializedName("ProcessCount")
    @Expose
    private Long ProcessCount;

    /**
    * 恶意文件数
    */
    @SerializedName("FileCount")
    @Expose
    private Long FileCount;

    /**
    * 是否首次扫描[false:否|true:是]
    */
    @SerializedName("IsFirstScan")
    @Expose
    private Boolean IsFirstScan;

    /**
    * 最后扫描时间
    */
    @SerializedName("ScanTime")
    @Expose
    private String ScanTime;

    /**
     * Get 影响主机数 
     * @return HostCount 影响主机数
     */
    public Long getHostCount() {
        return this.HostCount;
    }

    /**
     * Set 影响主机数
     * @param HostCount 影响主机数
     */
    public void setHostCount(Long HostCount) {
        this.HostCount = HostCount;
    }

    /**
     * Get 异常进程数 
     * @return ProcessCount 异常进程数
     */
    public Long getProcessCount() {
        return this.ProcessCount;
    }

    /**
     * Set 异常进程数
     * @param ProcessCount 异常进程数
     */
    public void setProcessCount(Long ProcessCount) {
        this.ProcessCount = ProcessCount;
    }

    /**
     * Get 恶意文件数 
     * @return FileCount 恶意文件数
     */
    public Long getFileCount() {
        return this.FileCount;
    }

    /**
     * Set 恶意文件数
     * @param FileCount 恶意文件数
     */
    public void setFileCount(Long FileCount) {
        this.FileCount = FileCount;
    }

    /**
     * Get 是否首次扫描[false:否|true:是] 
     * @return IsFirstScan 是否首次扫描[false:否|true:是]
     */
    public Boolean getIsFirstScan() {
        return this.IsFirstScan;
    }

    /**
     * Set 是否首次扫描[false:否|true:是]
     * @param IsFirstScan 是否首次扫描[false:否|true:是]
     */
    public void setIsFirstScan(Boolean IsFirstScan) {
        this.IsFirstScan = IsFirstScan;
    }

    /**
     * Get 最后扫描时间 
     * @return ScanTime 最后扫描时间
     */
    public String getScanTime() {
        return this.ScanTime;
    }

    /**
     * Set 最后扫描时间
     * @param ScanTime 最后扫描时间
     */
    public void setScanTime(String ScanTime) {
        this.ScanTime = ScanTime;
    }

    public MalwareRiskOverview() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public MalwareRiskOverview(MalwareRiskOverview source) {
        if (source.HostCount != null) {
            this.HostCount = new Long(source.HostCount);
        }
        if (source.ProcessCount != null) {
            this.ProcessCount = new Long(source.ProcessCount);
        }
        if (source.FileCount != null) {
            this.FileCount = new Long(source.FileCount);
        }
        if (source.IsFirstScan != null) {
            this.IsFirstScan = new Boolean(source.IsFirstScan);
        }
        if (source.ScanTime != null) {
            this.ScanTime = new String(source.ScanTime);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "HostCount", this.HostCount);
        this.setParamSimple(map, prefix + "ProcessCount", this.ProcessCount);
        this.setParamSimple(map, prefix + "FileCount", this.FileCount);
        this.setParamSimple(map, prefix + "IsFirstScan", this.IsFirstScan);
        this.setParamSimple(map, prefix + "ScanTime", this.ScanTime);

    }
}

