/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.asr.v20190614.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class SentenceRecognitionResponse extends AbstractModel {

    /**
    * 识别结果。
    */
    @SerializedName("Result")
    @Expose
    private String Result;

    /**
    * 请求的音频时长，单位为ms
    */
    @SerializedName("AudioDuration")
    @Expose
    private Long AudioDuration;

    /**
    * 词时间戳列表的长度
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("WordSize")
    @Expose
    private Long WordSize;

    /**
    * 词时间戳列表
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("WordList")
    @Expose
    private SentenceWord [] WordList;

    /**
    * 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 识别结果。 
     * @return Result 识别结果。
     */
    public String getResult() {
        return this.Result;
    }

    /**
     * Set 识别结果。
     * @param Result 识别结果。
     */
    public void setResult(String Result) {
        this.Result = Result;
    }

    /**
     * Get 请求的音频时长，单位为ms 
     * @return AudioDuration 请求的音频时长，单位为ms
     */
    public Long getAudioDuration() {
        return this.AudioDuration;
    }

    /**
     * Set 请求的音频时长，单位为ms
     * @param AudioDuration 请求的音频时长，单位为ms
     */
    public void setAudioDuration(Long AudioDuration) {
        this.AudioDuration = AudioDuration;
    }

    /**
     * Get 词时间戳列表的长度
注意：此字段可能返回 null，表示取不到有效值。 
     * @return WordSize 词时间戳列表的长度
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getWordSize() {
        return this.WordSize;
    }

    /**
     * Set 词时间戳列表的长度
注意：此字段可能返回 null，表示取不到有效值。
     * @param WordSize 词时间戳列表的长度
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setWordSize(Long WordSize) {
        this.WordSize = WordSize;
    }

    /**
     * Get 词时间戳列表
注意：此字段可能返回 null，表示取不到有效值。 
     * @return WordList 词时间戳列表
注意：此字段可能返回 null，表示取不到有效值。
     */
    public SentenceWord [] getWordList() {
        return this.WordList;
    }

    /**
     * Set 词时间戳列表
注意：此字段可能返回 null，表示取不到有效值。
     * @param WordList 词时间戳列表
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setWordList(SentenceWord [] WordList) {
        this.WordList = WordList;
    }

    /**
     * Get 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public SentenceRecognitionResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public SentenceRecognitionResponse(SentenceRecognitionResponse source) {
        if (source.Result != null) {
            this.Result = new String(source.Result);
        }
        if (source.AudioDuration != null) {
            this.AudioDuration = new Long(source.AudioDuration);
        }
        if (source.WordSize != null) {
            this.WordSize = new Long(source.WordSize);
        }
        if (source.WordList != null) {
            this.WordList = new SentenceWord[source.WordList.length];
            for (int i = 0; i < source.WordList.length; i++) {
                this.WordList[i] = new SentenceWord(source.WordList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Result", this.Result);
        this.setParamSimple(map, prefix + "AudioDuration", this.AudioDuration);
        this.setParamSimple(map, prefix + "WordSize", this.WordSize);
        this.setParamArrayObj(map, prefix + "WordList.", this.WordList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

