/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.util;

import com.google.common.collect.Maps;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigFileUtils {
    public static void checkConfigFileMetadata(ConfigFileMetadata configFileMetadata) {
        if (StringUtils.isBlank((String)configFileMetadata.getNamespace())) {
            throw new IllegalArgumentException("namespace cannot be empty.");
        }
        if (StringUtils.isBlank((String)configFileMetadata.getFileGroup())) {
            throw new IllegalArgumentException("file group cannot be empty.");
        }
        if (StringUtils.isBlank((String)configFileMetadata.getFileName())) {
            throw new IllegalArgumentException("file name cannot be empty.");
        }
    }

    public static Set<String> stringPropertyNames(Properties properties) {
        if (properties == null) {
            return Collections.emptySet();
        }
        LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)properties.size());
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (!(k instanceof String)) continue;
            map.put((String)k, v);
        }
        return map.keySet();
    }
}

