/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileConnector;
import com.tencent.polaris.api.plugin.configuration.ConfigFileResponse;
import com.tencent.polaris.api.plugin.filter.ConfigFileFilterChain;
import com.tencent.polaris.api.utils.ThreadPoolUtils;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.api.core.ConfigKVFile;
import com.tencent.polaris.configuration.client.internal.AbstractConfigFileRepo;
import com.tencent.polaris.configuration.client.internal.ConfigFileLongPullService;
import com.tencent.polaris.configuration.client.internal.ConfigFileManager;
import com.tencent.polaris.configuration.client.internal.ConfigFilePersistentHandler;
import com.tencent.polaris.configuration.client.internal.ExponentialRetryPolicy;
import com.tencent.polaris.configuration.client.internal.RetryPolicy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class RemoteConfigFileRepo
extends AbstractConfigFileRepo {
    private static final long INIT_VERSION = 0L;
    private static final int PULL_CONFIG_RETRY_TIMES = 3;
    private static ScheduledExecutorService pullExecutorService;
    private final AtomicReference<ConfigFile> remoteConfigFile;
    private final AtomicLong notifiedVersion;
    private final ConfigFileConnector configFileConnector;
    private final ConfigFileFilterChain configFileFilterChain;
    private final RetryPolicy retryPolicy;
    private ConfigFilePersistentHandler configFilePersistHandler;
    private final boolean fallbackToLocalCache;
    private final ConfigFileManager configFileManager;
    private final ConfigFileLongPullService pullService;
    private String token;

    public RemoteConfigFileRepo(SDKContext sdkContext, ConfigFileLongPullService pullService, ConfigFileFilterChain configFileFilterChain, ConfigFileConnector connector, ConfigFileMetadata configFileMetadata, ConfigFilePersistentHandler handler, ConfigFileManager configFileManager) {
        super(sdkContext, configFileMetadata);
        RemoteConfigFileRepo.createPullExecutorService();
        this.token = sdkContext.getConfig().getConfigFile().getServerConnector().getToken();
        this.remoteConfigFile = new AtomicReference();
        this.notifiedVersion = new AtomicLong(0L);
        this.retryPolicy = new ExponentialRetryPolicy(1L, 120L);
        this.configFilePersistHandler = handler;
        this.configFileFilterChain = configFileFilterChain;
        this.configFileManager = configFileManager;
        this.pullService = pullService;
        this.configFileConnector = connector;
        this.fallbackToLocalCache = sdkContext.getConfig().getConfigFile().getServerConnector().getFallbackToLocalCache();
        RemoteConfigFileRepo.registerRepoDestroyHook(sdkContext);
        this.pull();
        this.addToLongPollingPool(pullService, configFileMetadata);
        this.startCheckVersionTask();
    }

    private static void createPullExecutorService() {
        if (pullExecutorService == null || pullExecutorService.isShutdown() || pullExecutorService.isTerminated()) {
            pullExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("Configuration-Pull"));
        }
    }

    private void addToLongPollingPool(ConfigFileLongPullService pullService, ConfigFileMetadata configFileMetadata) {
        ConfigFile configFile = this.remoteConfigFile.get();
        if (configFile == null) {
            configFile = new ConfigFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName());
            configFile.setVersion(0L);
        }
        pullService.addConfigFile(this);
    }

    @Override
    public String getContent() {
        return this.remoteConfigFile.get() != null ? this.remoteConfigFile.get().getContent() : null;
    }

    @Override
    public String getMd5() {
        return this.remoteConfigFile.get() != null ? this.remoteConfigFile.get().getMd5() : "";
    }

    public long getConfigFileVersion() {
        if (this.remoteConfigFile.get() == null) {
            return 0L;
        }
        return this.remoteConfigFile.get().getVersion();
    }

    @Override
    protected void doPull() {
        long startTime = System.currentTimeMillis();
        ConfigFile pullConfigFileReq = new ConfigFile(this.configFileMetadata.getNamespace(), this.configFileMetadata.getFileGroup(), this.configFileMetadata.getFileName());
        pullConfigFileReq.setVersion(this.notifiedVersion.get());
        LOGGER.info("[Config] start pull config file. config file = {}, version = {}", (Object)this.configFileMetadata, (Object)this.notifiedVersion.get());
        int retryTimes = 0;
        while (retryTimes < 3) {
            try {
                ConfigFileResponse response = this.configFileFilterChain.execute(pullConfigFileReq, configFile -> this.configFileConnector.getConfigFile(pullConfigFileReq));
                this.retryPolicy.success();
                long pulledConfigFileVersion = response.getConfigFile() != null ? response.getConfigFile().getVersion() : -1L;
                LOGGER.info("[Config] pull config file finished. config file = {}, code = {}, version = {}, duration = {} ms", new Object[]{this.configFileMetadata, response.getCode(), pulledConfigFileVersion, System.currentTimeMillis() - startTime});
                if (response.getCode() == 200000) {
                    boolean shouldUpdateLocalCache;
                    ConfigFile pulledConfigFile = response.getConfigFile();
                    if (this.configFileConnector.isNotifiedVersionIncreaseStrictly()) {
                        shouldUpdateLocalCache = this.remoteConfigFile.get() == null || pulledConfigFile.getVersion() >= this.remoteConfigFile.get().getVersion();
                    } else {
                        boolean bl = shouldUpdateLocalCache = this.remoteConfigFile.get() == null || pulledConfigFile.getVersion() != this.remoteConfigFile.get().getVersion();
                    }
                    if (shouldUpdateLocalCache) {
                        ConfigFile copiedConfigFile = this.deepCloneConfigFile(pulledConfigFile);
                        this.remoteConfigFile.set(copiedConfigFile);
                        this.fireChangeEvent(copiedConfigFile.getContent());
                        this.configFilePersistHandler.asyncSaveConfigFile(pulledConfigFile);
                    }
                    return;
                }
                if (response.getCode() == 400202) {
                    LOGGER.warn("[Config] config file not found, please check whether config file released. {}", (Object)this.configFileMetadata);
                    this.configFilePersistHandler.asyncDeleteConfigFile(new ConfigFile(this.configFileMetadata.getNamespace(), this.configFileMetadata.getFileGroup(), this.configFileMetadata.getFileName()));
                    if (this.remoteConfigFile.get() != null) {
                        this.remoteConfigFile.set(null);
                        ConfigKVFile configKVFile = this.configFileManager.removeConfigKVFile(this.configFileMetadata);
                        this.pullService.removeConfigFile(this);
                        this.fireChangeEvent(null);
                    }
                    return;
                }
                LOGGER.error("[Config] pull response without expected code. retry times = {}, code = {}", (Object)retryTimes, (Object)response.getCode());
                this.retryPolicy.fail();
                this.retryPolicy.executeDelay();
                this.fallbackIfNecessary(++retryTimes, pullConfigFileReq);
            }
            catch (Throwable t) {
                LOGGER.error("[Config] failed to pull config file. retry times = " + retryTimes, t);
                this.retryPolicy.fail();
                this.retryPolicy.executeDelay();
                this.fallbackIfNecessary(++retryTimes, pullConfigFileReq);
            }
        }
    }

    private void fallbackIfNecessary(int retryTimes, ConfigFile configFileReq) {
        if (retryTimes >= 3 && this.fallbackToLocalCache) {
            ConfigFile configFileRes = this.configFilePersistHandler.loadPersistedConfigFile(configFileReq);
            if (configFileRes != null) {
                LOGGER.info("[Config] failed to pull config file from remote,fallback to local cache success.{}.", (Object)configFileRes);
                this.remoteConfigFile.set(configFileRes);
                this.fireChangeEvent(configFileRes.getContent());
                return;
            }
            LOGGER.info("[Config] failed to pull config file from remote,fallback to local cache fail.{}.", (Object)configFileReq);
        }
    }

    public void onLongPollNotified(long newVersion) {
        if (this.configFileConnector.isNotifiedVersionIncreaseStrictly() ? this.remoteConfigFile.get() != null && this.remoteConfigFile.get().getVersion() >= newVersion : this.remoteConfigFile.get() != null && this.remoteConfigFile.get().getVersion() == newVersion) {
            return;
        }
        this.notifiedVersion.set(newVersion);
        pullExecutorService.submit(this::pull);
    }

    private void startCheckVersionTask() {
        pullExecutorService.scheduleAtFixedRate(() -> {
            boolean shouldRetry;
            long pulledVersion;
            if (this.notifiedVersion == null || this.notifiedVersion.get() == 0L) {
                return;
            }
            long l = pulledVersion = this.remoteConfigFile.get() != null ? this.remoteConfigFile.get().getVersion() : 0L;
            if (this.configFileConnector.isNotifiedVersionIncreaseStrictly()) {
                shouldRetry = this.notifiedVersion.get() > pulledVersion;
            } else {
                boolean bl = shouldRetry = this.notifiedVersion.get() != pulledVersion;
            }
            if (shouldRetry) {
                LOGGER.info("[Config] notified version greater than pulled version, will pull config file.file = {}, notified version = {}, pulled version = {}", new Object[]{this.getConfigFileMetadata(), this.notifiedVersion, pulledVersion});
                this.pull();
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    private ConfigFile deepCloneConfigFile(ConfigFile sourceConfigFile) {
        ConfigFile configFile = new ConfigFile(sourceConfigFile.getNamespace(), sourceConfigFile.getFileGroup(), sourceConfigFile.getFileName());
        configFile.setContent(sourceConfigFile.getContent());
        configFile.setVersion(sourceConfigFile.getVersion());
        configFile.setMd5(sourceConfigFile.getMd5());
        return configFile;
    }

    public static void registerRepoDestroyHook(SDKContext context) {
        context.registerDestroyHook(new Destroyable(){

            protected void doDestroy() {
                RemoteConfigFileRepo.destroyPullExecutor();
            }
        });
    }

    static void destroyPullExecutor() {
        ThreadPoolUtils.waitAndStopThreadPools((ExecutorService[])new ExecutorService[]{pullExecutorService});
    }

    static {
        RemoteConfigFileRepo.createPullExecutorService();
    }
}

