/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileConnector;
import com.tencent.polaris.api.plugin.configuration.ConfigFileResponse;
import com.tencent.polaris.api.utils.ThreadPoolUtils;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.ExponentialRetryPolicy;
import com.tencent.polaris.configuration.client.internal.RemoteConfigFileRepo;
import com.tencent.polaris.configuration.client.internal.RetryPolicy;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class ConfigFileLongPullService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileLongPullService.class);
    private final ConfigFileConnector connector;
    private final ExecutorService longPollingService;
    private final Map<ConfigFileMetadata, RemoteConfigFileRepo> configFilePool;
    private final Map<ConfigFileMetadata, Long> notifiedVersion;
    private final AtomicReference<Boolean> started;
    private final AtomicBoolean isLongPullingStopped = new AtomicBoolean(false);
    private final RetryPolicy retryPolicy;

    public ConfigFileLongPullService(SDKContext sdkContext, ConfigFileConnector configFileConnector) {
        this.started = new AtomicReference<Boolean>(false);
        this.configFilePool = Maps.newConcurrentMap();
        this.notifiedVersion = Maps.newConcurrentMap();
        this.retryPolicy = new ExponentialRetryPolicy(1L, 120L);
        this.connector = configFileConnector;
        NamedThreadFactory threadFactory = new NamedThreadFactory("Configuration-LongPolling");
        this.longPollingService = Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
    }

    public void addConfigFile(RemoteConfigFileRepo remoteConfigFileRepo) {
        ConfigFileMetadata configFileMetadata = remoteConfigFileRepo.getConfigFileMetadata();
        long version = remoteConfigFileRepo.getConfigFileVersion();
        LOGGER.info("[Config] add long polling config file. file = {}, version = {}", (Object)configFileMetadata, (Object)version);
        this.configFilePool.putIfAbsent(configFileMetadata, remoteConfigFileRepo);
        this.notifiedVersion.putIfAbsent(configFileMetadata, version);
        if (!this.started.get().booleanValue()) {
            this.startLongPollingTask();
        }
    }

    public void removeConfigFile(RemoteConfigFileRepo remoteConfigFileRepo) {
        ConfigFileMetadata configFileMetadata = remoteConfigFileRepo.getConfigFileMetadata();
        long version = remoteConfigFileRepo.getConfigFileVersion();
        LOGGER.info("[Config] remove long polling config file. file = {}, version = {}", (Object)configFileMetadata, (Object)version);
        this.configFilePool.remove(configFileMetadata);
        this.notifiedVersion.remove(configFileMetadata);
    }

    private void startLongPollingTask() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        try {
            this.longPollingService.submit(() -> {
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.doLongPolling();
            });
        }
        catch (Throwable t) {
            this.started.set(false);
        }
    }

    private void doLongPolling() {
        while (!this.isLongPullingStopped.get() && !Thread.currentThread().isInterrupted()) {
            try {
                List<ConfigFile> watchConfigFiles = this.assembleWatchConfigFiles();
                LOGGER.debug("[Config] do long polling. config file size = {}, delay time = {}", (Object)watchConfigFiles.size(), (Object)this.retryPolicy.getCurrentDelayTime());
                ConfigFileResponse response = this.connector.watchConfigFiles(watchConfigFiles);
                this.retryPolicy.success();
                int responseCode = response.getCode();
                if (responseCode == 200000 && response.getConfigFile() != null) {
                    ConfigFile changedConfigFile = response.getConfigFile();
                    DefaultConfigFileMetadata metadata = new DefaultConfigFileMetadata(changedConfigFile.getNamespace(), changedConfigFile.getFileGroup(), changedConfigFile.getFileName());
                    long newNotifiedVersion = changedConfigFile.getVersion();
                    long oldNotifiedVersion = this.notifiedVersion.get(metadata);
                    long maxVersion = newNotifiedVersion;
                    if (this.connector.isNotifiedVersionIncreaseStrictly()) {
                        maxVersion = Math.max(newNotifiedVersion, oldNotifiedVersion);
                    }
                    this.notifiedVersion.put(metadata, maxVersion);
                    LOGGER.info("[Config] received change event by long polling. file = {}, new version = {}, old version = {}", new Object[]{metadata, newNotifiedVersion, oldNotifiedVersion});
                    RemoteConfigFileRepo remoteConfigFileRepo = this.configFilePool.get(metadata);
                    remoteConfigFileRepo.onLongPollNotified(maxVersion);
                    continue;
                }
                if (responseCode == 200001) {
                    LOGGER.info("[Config] long polling result: data no change");
                    continue;
                }
                LOGGER.error("[Config] long polling result with unexpect code. code = {}", (Object)responseCode);
                this.retryPolicy.fail();
                this.retryPolicy.executeDelay();
            }
            catch (Throwable t) {
                LOGGER.error("[Config] long polling failed.", t);
                this.retryPolicy.fail();
                this.retryPolicy.executeDelay();
            }
        }
    }

    private List<ConfigFile> assembleWatchConfigFiles() {
        ArrayList watchConfigFiles = Lists.newArrayList();
        for (Map.Entry<ConfigFileMetadata, RemoteConfigFileRepo> entry : this.configFilePool.entrySet()) {
            RemoteConfigFileRepo remoteConfigFileRepo = entry.getValue();
            ConfigFileMetadata metadata = remoteConfigFileRepo.getConfigFileMetadata();
            ConfigFile configFile = new ConfigFile(metadata.getNamespace(), metadata.getFileGroup(), metadata.getFileName());
            configFile.setVersion(this.notifiedVersion.get(metadata).longValue());
            watchConfigFiles.add(configFile);
        }
        return watchConfigFiles;
    }

    public void stopLongPulling() {
        this.isLongPullingStopped.compareAndSet(false, true);
    }

    public void doLongPullingDestroy() {
        this.stopLongPulling();
        if (this.longPollingService != null) {
            ThreadPoolUtils.waitAndStopThreadPools((ExecutorService[])new ExecutorService[]{this.longPollingService});
        }
    }
}

