/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.tencent.polaris.configuration.api.core.ConfigFileChangeListener;
import com.tencent.polaris.configuration.api.core.ConfigKVFile;
import com.tencent.polaris.configuration.api.core.ConfigKVFileChangeListener;
import com.tencent.polaris.configuration.client.util.ConfigFileUtils;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class CompositeConfigFile
implements ConfigKVFile {
    private final List<ConfigKVFile> configKVFiles;
    private final AtomicReference<Properties> properties = new AtomicReference();

    public CompositeConfigFile(List<ConfigKVFile> configKVFiles) {
        this.configKVFiles = Collections.unmodifiableList(configKVFiles);
        Properties properties = new Properties();
        for (ConfigKVFile configKVFile : configKVFiles) {
            for (String name : configKVFile.getPropertyNames()) {
                if (properties.containsKey(name)) continue;
                properties.put(name, configKVFile.getProperty(name, null));
            }
        }
        this.properties.set(properties);
    }

    public List<ConfigKVFile> getConfigKVFiles() {
        return this.configKVFiles;
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.properties.get().getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Integer getIntProperty(String key, Integer defaultValue) {
        throw new UnsupportedOperationException();
    }

    public Long getLongProperty(String key, Long defaultValue) {
        throw new UnsupportedOperationException();
    }

    public Short getShortProperty(String key, Short defaultValue) {
        throw new UnsupportedOperationException();
    }

    public Float getFloatProperty(String key, Float defaultValue) {
        throw new UnsupportedOperationException();
    }

    public Double getDoubleProperty(String key, Double defaultValue) {
        throw new UnsupportedOperationException();
    }

    public Byte getByteProperty(String key, Byte defaultValue) {
        throw new UnsupportedOperationException();
    }

    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        throw new UnsupportedOperationException();
    }

    public String[] getArrayProperty(String key, String delimiter, String[] defaultValue) {
        throw new UnsupportedOperationException();
    }

    public <T extends Enum<T>> T getEnumProperty(String key, Class<T> enumType, T defaultValue) {
        throw new UnsupportedOperationException();
    }

    public <T> T getJsonProperty(String key, Class<T> clazz, T defaultValue) {
        throw new UnsupportedOperationException();
    }

    public <T> T getJsonProperty(String key, Type typeOfT, T defaultValue) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getPropertyNames() {
        return ConfigFileUtils.stringPropertyNames(this.properties.get());
    }

    public void addChangeListener(ConfigKVFileChangeListener listener) {
        for (ConfigKVFile configKVFile : this.configKVFiles) {
            configKVFile.addChangeListener(listener);
        }
    }

    public void removeChangeListener(ConfigKVFileChangeListener listener) {
        for (ConfigKVFile configKVFile : this.configKVFiles) {
            configKVFile.removeChangeListener(listener);
        }
    }

    public String getContent() {
        throw new UnsupportedOperationException();
    }

    public <T> T asJson(Class<T> objectType, T defaultValue) {
        throw new UnsupportedOperationException();
    }

    public <T> T asJson(Type typeOfT, T defaultValue) {
        throw new UnsupportedOperationException();
    }

    public boolean hasContent() {
        throw new UnsupportedOperationException();
    }

    public String getMd5() {
        throw new UnsupportedOperationException();
    }

    public void addChangeListener(ConfigFileChangeListener listener) {
        for (ConfigKVFile configKVFile : this.configKVFiles) {
            configKVFile.addChangeListener(listener);
        }
    }

    public void removeChangeListener(ConfigFileChangeListener listener) {
        for (ConfigKVFile configKVFile : this.configKVFiles) {
            configKVFile.removeChangeListener(listener);
        }
    }

    public String getNamespace() {
        return "";
    }

    public String getFileGroup() {
        return "";
    }

    public String getFileName() {
        return "";
    }
}

