/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugin.lossless.register;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.tencent.polaris.api.config.provider.LosslessConfig;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.HttpServerAware;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.lossless.InstanceProperties;
import com.tencent.polaris.api.plugin.lossless.LosslessActionProvider;
import com.tencent.polaris.api.plugin.lossless.LosslessPolicy;
import com.tencent.polaris.api.plugin.lossless.RegisterStatus;
import com.tencent.polaris.api.pojo.BaseInstance;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.pojo.Event;
import com.tencent.polaris.client.util.HttpServerUtils;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugin.lossless.common.LosslessUtils;
import com.tencent.polaris.specification.api.v1.traffic.manage.LosslessProto;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class HealthCheckRegisterLosslessPolicy
implements LosslessPolicy,
HttpServerAware {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckRegisterLosslessPolicy.class);
    private static final Logger EVENT_LOG = LoggerFactory.getLogger((String)"polaris-lossless-event");
    private LosslessConfig losslessConfig;
    private ValueContext valueContext;
    private Extensions extensions;
    private final ScheduledExecutorService healthCheckExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("lossless-register-check"));
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public String getName() {
        return "health-check-register-lossless";
    }

    public PluginType getType() {
        return PluginTypes.LOSSLESS_POLICY.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        this.losslessConfig = ctx.getConfig().getProvider().getLossless();
        this.valueContext = ctx.getValueContext();
        if (!this.valueContext.containsValue("key-register-status")) {
            ConcurrentHashMap registerStatuses = new ConcurrentHashMap();
            this.valueContext.setValue("key-register-status", registerStatuses);
        }
        if (!this.valueContext.containsValue("key-register-timestamp")) {
            ConcurrentHashMap registerTimestamps = new ConcurrentHashMap();
            this.valueContext.setValue("key-register-timestamp", registerTimestamps);
        }
    }

    public void postContextInit(Extensions ctx) throws PolarisException {
        this.extensions = ctx;
    }

    public void destroy() {
        this.stopped.set(true);
        this.healthCheckExecutor.shutdownNow();
    }

    public int getOrder() {
        return 0;
    }

    public void buildInstanceProperties(InstanceProperties instanceProperties) {
    }

    public void losslessRegister(BaseInstance instance, InstanceProperties instanceProperties) {
        LOG.info("[HealthCheckRegisterLosslessPolicy] start to do lossless register by plugin {}", (Object)this.getName());
        Map actionProviders = (Map)this.valueContext.getValue("key_losslessActionProvider");
        if (CollectionUtils.isEmpty((Map)actionProviders)) {
            LOG.warn("[HealthCheckRegisterLosslessPolicy] LosslessActionProvider not found, no lossless action will be taken");
            return;
        }
        if (this.stopped.get()) {
            LOG.info("[HealthCheckRegisterLosslessPolicy] plugin {} stopped, not lossless register action will be taken", (Object)this.getName());
            return;
        }
        LosslessActionProvider losslessActionProvider = (LosslessActionProvider)actionProviders.get(instance);
        if (null == losslessActionProvider) {
            LOG.warn("[HealthCheckRegisterLosslessPolicy] LosslessActionProvider for instance {} not found, no lossless action will be taken", (Object)instance);
            return;
        }
        this.doLosslessRegister(instance, losslessActionProvider, instanceProperties);
    }

    public void losslessDeregister(BaseInstance instance) {
    }

    private void doLosslessRegister(final BaseInstance instance, final LosslessActionProvider losslessActionProvider, final InstanceProperties instanceProperties) {
        if (!this.isDelayRegisterEnable(instance)) {
            LOG.info("[HealthCheckRegisterLosslessPolicy] console lossless register disabled, start to do register now");
            this.doRegister(instance, losslessActionProvider, instanceProperties, false);
            return;
        }
        LOG.info("[HealthCheckRegisterLosslessPolicy] do losslessRegister for instance {}", (Object)instance);
        if (!losslessActionProvider.isEnableHealthCheck()) {
            long delayRegisterInterval = this.getDelayRegisterInterval(instance);
            LOG.info("[HealthCheckRegisterLosslessPolicy] health check disabled, start lossless register after {}ms, plugin {}", (Object)delayRegisterInterval, (Object)this.getName());
            Event delayRegisterStartEvent = new Event(this.valueContext.getClientId(), instance, "LosslessDelayRegisterStart");
            EVENT_LOG.info(delayRegisterStartEvent.toString());
            this.healthCheckExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    LOG.info("[HealthCheckRegisterLosslessPolicy] health-check disabled, start to do register now");
                    HealthCheckRegisterLosslessPolicy.this.doRegister(instance, losslessActionProvider, instanceProperties, true);
                }
            }, delayRegisterInterval, TimeUnit.MILLISECONDS);
        } else {
            long healthCheckInterval = this.getHealthCheckInterval(instance);
            LOG.info("[HealthCheckRegisterLosslessPolicy] health check enabled, start lossless register after check, interval {}ms, plugin {}", (Object)healthCheckInterval, (Object)this.getName());
            HealthChecker healthChecker = new HealthChecker(instance, losslessActionProvider, instanceProperties);
            this.healthCheckExecutor.schedule(healthChecker, healthCheckInterval, TimeUnit.MILLISECONDS);
        }
    }

    private void doRegister(BaseInstance instance, LosslessActionProvider losslessActionProvider, InstanceProperties instanceProperties, boolean isDelayRegister) {
        losslessActionProvider.doRegister(instanceProperties);
        Map registerStatusMap = (Map)this.valueContext.getValue("key-register-status");
        registerStatusMap.put(instance, RegisterStatus.REGISTERED);
        String clientId = this.valueContext.getClientId();
        if (isDelayRegister) {
            EVENT_LOG.info(new Event(clientId, instance, "LosslessRegister").toString());
        } else {
            EVENT_LOG.info(new Event(clientId, instance, "DirectRegister").toString());
        }
        int warmupInterval = this.getWarmupInterval(instance);
        if (warmupInterval > 0) {
            LOG.info("[HealthCheckRegisterLosslessPolicy] warmup for instance {}, warmupInterval:{}ms", (Object)instance, (Object)warmupInterval);
            Map registerTimestamp = (Map)this.valueContext.getValue("key-register-timestamp");
            registerTimestamp.put(instance, System.currentTimeMillis());
            Event warmupStartEvent = new Event(clientId, instance, "LosslessWarmupStart");
            EVENT_LOG.info(warmupStartEvent.toString());
            this.healthCheckExecutor.schedule(() -> {
                LOG.info("[HealthCheckRegisterLosslessPolicy] warmup for instance {} finished", (Object)instance);
                Event warmupEndEvent = new Event(clientId, instance, "LosslessWarmupEnd");
                EVENT_LOG.info(warmupEndEvent.toString());
            }, (long)warmupInterval, TimeUnit.MILLISECONDS);
        } else {
            LOG.info("[HealthCheckRegisterLosslessPolicy] no warmup for instance {}", (Object)instance);
        }
    }

    public String getHost() {
        return this.losslessConfig.getHost();
    }

    public int getPort() {
        return this.losslessConfig.getPort();
    }

    static RegisterStatus checkRegisterStatus(Collection<BaseInstance> instances, Map<BaseInstance, RegisterStatus> registerStatuses) {
        RegisterStatus finalStatus = RegisterStatus.REGISTERED;
        if (CollectionUtils.isNotEmpty(instances)) {
            if (CollectionUtils.isNotEmpty(registerStatuses)) {
                for (BaseInstance baseInstance : instances) {
                    RegisterStatus registerStatus = registerStatuses.get(baseInstance);
                    if (registerStatus == RegisterStatus.REGISTERED) continue;
                    finalStatus = RegisterStatus.UNREGISTERED;
                    LOG.info("[HealthCheckRegisterLosslessPolicy] instance {} not register, register status is unregistered", (Object)baseInstance);
                    break;
                }
            } else {
                LOG.info("[HealthCheckRegisterLosslessPolicy] no instances registered, register status is unregistered");
                finalStatus = RegisterStatus.UNREGISTERED;
            }
        } else {
            LOG.info("[HealthCheckRegisterLosslessPolicy] instances is empty, register status is unregistered");
            finalStatus = RegisterStatus.UNREGISTERED;
        }
        return finalStatus;
    }

    public Map<String, HttpHandler> getHandlers() {
        if (!this.losslessConfig.isEnable()) {
            return Collections.emptyMap();
        }
        HashMap<String, HttpHandler> handlers = new HashMap<String, HttpHandler>();
        handlers.put("/readiness", new ReadinessHttpHandler());
        handlers.put("/online", new ReadinessHttpHandler());
        return handlers;
    }

    public boolean allowPortDrift() {
        return false;
    }

    private boolean isDelayRegisterEnable(BaseInstance baseInstance) {
        LosslessProto.LosslessRule losslessRule = LosslessUtils.getMatchLosslessRule((Extensions)this.extensions, (BaseInstance)baseInstance);
        return Optional.ofNullable(losslessRule).map(LosslessProto.LosslessRule::getLosslessOnline).map(LosslessProto.LosslessOnline::getDelayRegister).map(LosslessProto.DelayRegister::getEnable).orElse(true);
    }

    private int getWarmupInterval(BaseInstance baseInstance) {
        LosslessProto.LosslessRule losslessRule = LosslessUtils.getMatchLosslessRule((Extensions)this.extensions, (BaseInstance)baseInstance);
        return Optional.ofNullable(losslessRule).map(LosslessProto.LosslessRule::getLosslessOnline).map(LosslessProto.LosslessOnline::getWarmup).filter(LosslessProto.Warmup::getEnable).map(LosslessProto.Warmup::getIntervalSecond).map(interval -> interval * 1000).orElse(0);
    }

    private long getDelayRegisterInterval(BaseInstance baseInstance) {
        LosslessProto.LosslessRule losslessRule = LosslessUtils.getMatchLosslessRule((Extensions)this.extensions, (BaseInstance)baseInstance);
        return Optional.ofNullable(losslessRule).map(LosslessProto.LosslessRule::getLosslessOnline).map(LosslessProto.LosslessOnline::getDelayRegister).map(LosslessProto.DelayRegister::getIntervalSecond).map(Long::valueOf).map(interval -> interval * 1000L).orElse(this.losslessConfig.getDelayRegisterInterval());
    }

    private long getHealthCheckInterval(BaseInstance baseInstance) {
        LosslessProto.LosslessRule losslessRule = LosslessUtils.getMatchLosslessRule((Extensions)this.extensions, (BaseInstance)baseInstance);
        return Optional.ofNullable(losslessRule).map(LosslessProto.LosslessRule::getLosslessOnline).map(LosslessProto.LosslessOnline::getDelayRegister).map(LosslessProto.DelayRegister::getHealthCheckIntervalSecond).map(Long::valueOf).map(interval -> interval * 1000L).orElse(this.losslessConfig.getHealthCheckInterval());
    }

    private boolean isLosslessReadinessEnable(BaseInstance instance) {
        LosslessProto.LosslessRule losslessRule = LosslessUtils.getMatchLosslessRule((Extensions)this.extensions, (BaseInstance)instance);
        return Optional.ofNullable(losslessRule).map(LosslessProto.LosslessRule::getLosslessOnline).map(LosslessProto.LosslessOnline::getReadiness).map(LosslessProto.Readiness::getEnable).orElse(true);
    }

    private Set<BaseInstance> getNeedReadinessInstances(Set<BaseInstance> instances) {
        HashSet<BaseInstance> needReadinessInstances = new HashSet<BaseInstance>();
        for (BaseInstance instance : instances) {
            if (this.isLosslessReadinessEnable(instance)) {
                needReadinessInstances.add(instance);
                continue;
            }
            LOG.debug("[getNeedOfflineInstances] lossless readiness is disabled for instance {}", (Object)instance);
        }
        return needReadinessInstances;
    }

    class ReadinessHttpHandler
    implements HttpHandler {
        private RegisterStatus lastFinalStatus;

        ReadinessHttpHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            Map actionProviders = (Map)HealthCheckRegisterLosslessPolicy.this.valueContext.getValue("key_losslessActionProvider");
            Map registerStatuses = (Map)HealthCheckRegisterLosslessPolicy.this.valueContext.getValue("key-register-status");
            Set needReadinessInstances = HealthCheckRegisterLosslessPolicy.this.getNeedReadinessInstances(actionProviders.keySet());
            if (CollectionUtils.isEmpty((Collection)needReadinessInstances)) {
                LOG.debug("[LosslessDeRegister] no instance needs to be ready");
                HttpServerUtils.writeTextToHttpServer((HttpExchange)exchange, (String)"", (int)404);
                return;
            }
            RegisterStatus finalStatus = HealthCheckRegisterLosslessPolicy.checkRegisterStatus(needReadinessInstances, registerStatuses);
            if (finalStatus != this.lastFinalStatus) {
                LOG.info("[HealthCheckRegisterLosslessPolicy] receive /online request for instances {}, finalStatus from {} to {}", new Object[]{needReadinessInstances, this.lastFinalStatus, finalStatus});
                this.lastFinalStatus = finalStatus;
            } else {
                LOG.debug("[HealthCheckRegisterLosslessPolicy] receive /online request for instances {}, finalStatus from {} to {}", new Object[]{needReadinessInstances, this.lastFinalStatus, finalStatus});
            }
            HttpServerUtils.writeTextToHttpServer((HttpExchange)exchange, (String)finalStatus.toString(), (int)(finalStatus == RegisterStatus.REGISTERED ? 200 : 503));
        }
    }

    private class HealthChecker
    implements Runnable {
        final BaseInstance instance;
        final LosslessActionProvider losslessActionProvider;
        final InstanceProperties instanceProperties;

        public HealthChecker(BaseInstance instance, LosslessActionProvider losslessActionProvider, InstanceProperties instanceProperties) {
            this.instance = instance;
            this.losslessActionProvider = losslessActionProvider;
            this.instanceProperties = instanceProperties;
        }

        @Override
        public void run() {
            boolean result = this.losslessActionProvider.doHealthCheck();
            LOG.info("[HealthCheckRegisterLosslessPolicy] do health-check for lossless register, result {}", (Object)result);
            if (!result) {
                HealthCheckRegisterLosslessPolicy.this.healthCheckExecutor.schedule(this, HealthCheckRegisterLosslessPolicy.this.getHealthCheckInterval(this.instance), TimeUnit.MILLISECONDS);
                return;
            }
            LOG.info("[HealthCheckRegisterLosslessPolicy] health-check success, start to do register");
            try {
                HealthCheckRegisterLosslessPolicy.this.doRegister(this.instance, this.losslessActionProvider, this.instanceProperties, true);
            }
            catch (Throwable throwable) {
                LOG.error("[HealthCheckRegisterLosslessPolicy] fail to do lossless register in plugin {}", (Object)HealthCheckRegisterLosslessPolicy.this.getName(), (Object)throwable);
            }
        }
    }
}

