/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugin.lossless.deregister;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.tencent.polaris.api.config.provider.LosslessConfig;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.HttpServerAware;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.lossless.InstanceProperties;
import com.tencent.polaris.api.plugin.lossless.LosslessActionProvider;
import com.tencent.polaris.api.plugin.lossless.LosslessPolicy;
import com.tencent.polaris.api.plugin.lossless.RegisterStatus;
import com.tencent.polaris.api.pojo.BaseInstance;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.pojo.Event;
import com.tencent.polaris.client.util.HttpServerUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugin.lossless.common.LosslessUtils;
import com.tencent.polaris.specification.api.v1.traffic.manage.LosslessProto;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class DeregisterLosslessPolicy
implements LosslessPolicy,
HttpServerAware {
    private static final Logger LOG = LoggerFactory.getLogger(DeregisterLosslessPolicy.class);
    private static final Logger EVENT_LOG = LoggerFactory.getLogger((String)"polaris-lossless-event");
    private LosslessConfig losslessConfig;
    private ValueContext valueContext;
    private Extensions extensions;

    public String getHost() {
        return this.losslessConfig.getHost();
    }

    public int getPort() {
        return this.losslessConfig.getPort();
    }

    public Map<String, HttpHandler> getHandlers() {
        if (!this.losslessConfig.isEnable()) {
            return Collections.emptyMap();
        }
        HashMap<String, HttpHandler> handlers = new HashMap<String, HttpHandler>();
        handlers.put("/offline", new DeregisterHandler());
        return handlers;
    }

    public boolean allowPortDrift() {
        return false;
    }

    public String getName() {
        return "deregister-lossless";
    }

    public PluginType getType() {
        return PluginTypes.LOSSLESS_POLICY.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        this.losslessConfig = ctx.getConfig().getProvider().getLossless();
        this.valueContext = ctx.getValueContext();
        if (!this.valueContext.containsValue("key-register-status")) {
            ConcurrentHashMap registerStatuses = new ConcurrentHashMap();
            this.valueContext.setValue("key-register-status", registerStatuses);
        }
    }

    public void postContextInit(Extensions ctx) throws PolarisException {
        this.extensions = ctx;
    }

    public void destroy() {
    }

    public int getOrder() {
        return 1;
    }

    public void buildInstanceProperties(InstanceProperties instanceProperties) {
    }

    public void losslessRegister(BaseInstance instance, InstanceProperties instanceProperties) {
    }

    public void losslessDeregister(BaseInstance instance) {
        Map actionProviders = (Map)this.valueContext.getValue("key_losslessActionProvider");
        if (CollectionUtils.isEmpty((Map)actionProviders)) {
            LOG.warn("[LosslessDeRegister] LosslessActionProvider not found, no lossless action will be taken for instance {}", (Object)instance);
            return;
        }
        LosslessActionProvider losslessActionProvider = (LosslessActionProvider)actionProviders.get(instance);
        if (null == losslessActionProvider) {
            LOG.warn("[LosslessDeRegister] LosslessActionProvider not found for instance {}", (Object)instance);
            return;
        }
        this.doLosslessDeregister(instance, losslessActionProvider);
    }

    private void doLosslessDeregister(BaseInstance instance, LosslessActionProvider actionProvider) {
        actionProvider.doDeregister();
        Map registerStatusMap = (Map)this.valueContext.getValue("key-register-status");
        registerStatusMap.put(instance, RegisterStatus.UNREGISTERED);
        String clientId = this.valueContext.getClientId();
        Event event = new Event();
        event.setClientId(clientId);
        event.setBaseInstance(instance);
        event.setEventName("LosslessDeregister");
        EVENT_LOG.info(event.toString());
    }

    private boolean isLosslessOfflineEnable(BaseInstance instance) {
        LosslessProto.LosslessRule losslessRule = LosslessUtils.getMatchLosslessRule((Extensions)this.extensions, (BaseInstance)instance);
        return Optional.ofNullable(losslessRule).map(LosslessProto.LosslessRule::getLosslessOffline).map(LosslessProto.LosslessOffline::getEnable).orElse(true);
    }

    private Set<BaseInstance> getNeedOfflineInstances(Set<BaseInstance> instances) {
        HashSet<BaseInstance> needOfflineInstances = new HashSet<BaseInstance>();
        for (BaseInstance instance : instances) {
            if (this.isLosslessOfflineEnable(instance)) {
                needOfflineInstances.add(instance);
                continue;
            }
            LOG.info("[LosslessDeregister] lossless offline is disabled for instance {}", (Object)instance);
        }
        return needOfflineInstances;
    }

    private class DeregisterHandler
    implements HttpHandler {
        private DeregisterHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            int code;
            String text;
            InetSocketAddress remoteAddress = exchange.getRemoteAddress();
            LOG.info("[LosslessDeregister] received lossless deregister request from {}", (Object)remoteAddress);
            if (!remoteAddress.getAddress().isLoopbackAddress()) {
                LOG.warn("[LosslessDeRegister] only loop-back address (like localhost or 127.0.0.1) can call this path");
                HttpServerUtils.writeTextToHttpServer((HttpExchange)exchange, (String)"only localhost can call this path", (int)403);
                return;
            }
            Map actionProviders = (Map)DeregisterLosslessPolicy.this.valueContext.getValue("key_losslessActionProvider");
            if (CollectionUtils.isEmpty((Map)actionProviders)) {
                LOG.warn("[LosslessDeRegister] LosslessActionProvider not found, no lossless action will be taken");
                HttpServerUtils.writeTextToHttpServer((HttpExchange)exchange, (String)"no action", (int)200);
                return;
            }
            List losslessPolicies = DeregisterLosslessPolicy.this.extensions.getLosslessPolicies();
            if (CollectionUtils.isEmpty((Collection)losslessPolicies)) {
                LOG.warn("[LosslessDeRegister] lossless is disabled, no losslessDeregister will do");
                HttpServerUtils.writeTextToHttpServer((HttpExchange)exchange, (String)"no policy", (int)500);
                return;
            }
            Set needOfflineInstances = DeregisterLosslessPolicy.this.getNeedOfflineInstances(actionProviders.keySet());
            if (CollectionUtils.isEmpty((Collection)needOfflineInstances)) {
                LOG.warn("[LosslessDeRegister] no instance needs to be offline");
                HttpServerUtils.writeTextToHttpServer((HttpExchange)exchange, (String)"", (int)404);
                return;
            }
            try {
                for (BaseInstance instance : needOfflineInstances) {
                    for (LosslessPolicy losslessPolicy : losslessPolicies) {
                        losslessPolicy.losslessDeregister(instance);
                    }
                }
                text = "ok";
                code = 200;
            }
            catch (Throwable e) {
                LOG.error("[LosslessDeRegister] fail to execute deregister", e);
                text = "failed: " + e.getMessage();
                code = 500;
            }
            HttpServerUtils.writeTextToHttpServer((HttpExchange)exchange, (String)text, (int)code);
        }
    }
}

