/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.event.tsf;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tencent.polaris.api.config.global.EventReporterConfig;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.event.EventReporter;
import com.tencent.polaris.api.plugin.event.FlowEvent;
import com.tencent.polaris.api.plugin.event.tsf.TsfEventDataConstants;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.api.utils.ThreadPoolUtils;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.event.tsf.TsfEventDataUtils;
import com.tencent.polaris.plugins.event.tsf.TsfEventReporterConfig;
import com.tencent.polaris.plugins.event.tsf.v1.EventResponse;
import com.tencent.polaris.plugins.event.tsf.v1.TsfEventData;
import com.tencent.polaris.plugins.event.tsf.v1.TsfEventDataPair;
import com.tencent.polaris.plugins.event.tsf.v1.TsfGenericEvent;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

public class TsfEventReporter
implements EventReporter {
    private static final Logger LOG = LoggerFactory.getLogger(TsfEventReporter.class);
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private final BlockingQueue<TsfEventData> v1EventQueue = new LinkedBlockingQueue<TsfEventData>(TsfEventDataConstants.QUEUE_THRESHOLD);
    private volatile boolean init = true;
    private TsfEventReporterConfig tsfEventReporterConfig;
    private URI v1EventUri;
    private final ScheduledExecutorService eventV1Executors = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("event-tsf-v1"));

    public boolean reportEvent(FlowEvent flowEvent) {
        if (flowEvent.getEventType().equals((Object)ServiceEventKey.EventType.CIRCUIT_BREAKING)) {
            return this.reportV1Event(flowEvent);
        }
        return true;
    }

    private boolean reportV1Event(FlowEvent flowEvent) {
        try {
            if (this.v1EventUri == null) {
                LOG.warn("build event request url fail, can not sent event.");
                return false;
            }
            TsfEventData eventData = new TsfEventData();
            eventData.setOccurTime(flowEvent.getTimestamp().getEpochSecond());
            eventData.setEventName(TsfEventDataUtils.convertEventName(flowEvent));
            Byte status = TsfEventDataUtils.convertStatus(flowEvent);
            if (status == null || status == -1) {
                return true;
            }
            eventData.setStatus(status);
            ArrayList<TsfEventDataPair> dimensions = new ArrayList<TsfEventDataPair>();
            dimensions.add(new TsfEventDataPair("app_id", this.tsfEventReporterConfig.getAppId()));
            dimensions.add(new TsfEventDataPair("namespace_id", this.tsfEventReporterConfig.getTsfNamespaceId()));
            dimensions.add(new TsfEventDataPair("service_name", this.tsfEventReporterConfig.getServiceName()));
            eventData.setDimensions(dimensions);
            ArrayList<TsfEventDataPair> additionalMsg = new ArrayList<TsfEventDataPair>();
            additionalMsg.add(new TsfEventDataPair("upstream_service", this.tsfEventReporterConfig.getServiceName()));
            additionalMsg.add(new TsfEventDataPair("upstream_namespace", this.tsfEventReporterConfig.getTsfNamespaceId()));
            additionalMsg.add(new TsfEventDataPair("downstream_service", flowEvent.getService()));
            additionalMsg.add(new TsfEventDataPair("downstream_namespace", flowEvent.getNamespace()));
            String isolationObject = "";
            for (Map.Entry entry : flowEvent.getAdditionalParams().entrySet()) {
                additionalMsg.add(new TsfEventDataPair((String)entry.getKey(), (String)entry.getValue()));
                if (!StringUtils.equals((String)((String)entry.getKey()), (String)"isolation_object")) continue;
                isolationObject = (String)entry.getValue();
            }
            eventData.setAdditionalMsg(additionalMsg);
            if (StringUtils.isNotBlank((String)isolationObject)) {
                eventData.setInstanceId(this.tsfEventReporterConfig.getInstanceId() + "#" + isolationObject);
            } else {
                eventData.setInstanceId(this.tsfEventReporterConfig.getInstanceId());
            }
            try {
                this.v1EventQueue.add(eventData);
            }
            catch (Exception e) {
                LOG.warn("eventQueue is full. Log this event and drop it. {}", (Object)flowEvent);
            }
            return true;
        }
        catch (Throwable throwable) {
            LOG.warn("Failed to send event to TSF. {}", (Object)flowEvent, (Object)throwable);
            return false;
        }
    }

    public String getName() {
        return "tsf";
    }

    public PluginType getType() {
        return PluginTypes.EVENT_REPORTER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        EventReporterConfig eventReporterConfig = ctx.getConfig().getGlobal().getEventReporter();
        if (eventReporterConfig != null && CollectionUtils.isNotEmpty((Collection)eventReporterConfig.getReporters())) {
            for (String reporter : eventReporterConfig.getReporters()) {
                if (!StringUtils.equals((String)this.getName(), (String)reporter)) continue;
                this.tsfEventReporterConfig = (TsfEventReporterConfig)ctx.getConfig().getGlobal().getEventReporter().getPluginConfig(this.getName(), TsfEventReporterConfig.class);
                this.init = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postContextInit(Extensions ctx) throws PolarisException {
        if (!this.init) {
            TsfEventReporter tsfEventReporter = this;
            synchronized (tsfEventReporter) {
                if (!this.init) {
                    this.init = true;
                    try {
                        String v1Path = String.format("/v1/event/%s/%s", URLEncoder.encode(this.tsfEventReporterConfig.getServiceName(), "UTF-8"), URLEncoder.encode(this.tsfEventReporterConfig.getInstanceId(), "UTF-8"));
                        this.v1EventUri = new URIBuilder().setScheme("http").setHost(this.tsfEventReporterConfig.getEventMasterIp()).setPort(this.tsfEventReporterConfig.getEventMasterPort().intValue()).setPath(v1Path).setParameter("token", this.tsfEventReporterConfig.getToken()).build();
                        LOG.info("Tsf event reporter init with v1 uri: {}", (Object)this.v1EventUri);
                        this.eventV1Executors.scheduleWithFixedDelay(new TsfEventV1Task(), 1000L, 1000L, TimeUnit.MILLISECONDS);
                        LOG.info("Tsf event reporter starts reporting task.");
                    }
                    catch (UnsupportedEncodingException | URISyntaxException e) {
                        LOG.error("Build event request url fail.", (Throwable)e);
                    }
                }
            }
        }
    }

    public void destroy() {
        ThreadPoolUtils.waitAndStopThreadPools((ExecutorService[])new ExecutorService[]{this.eventV1Executors});
    }

    private void postV1Event(TsfGenericEvent genericEvent) {
        StringEntity postBody = null;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(2000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            HttpPost httpPost = new HttpPost(this.v1EventUri);
            postBody = new StringEntity(gson.toJson((Object)genericEvent));
            httpPost.setEntity((HttpEntity)postBody);
            httpPost.setHeader("Content-Type", "application/json");
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            String resultString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
            EventResponse response = (EventResponse)gson.fromJson(resultString, EventResponse.class);
            if (response.getRetCode() != 0) {
                throw new RuntimeException("Report v1 event failed. Response = [" + resultString + "].");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("postV1Event body:{}", (Object)postBody);
            }
            LOG.info("Report v1 event To TSF event-center Success. Response is : {}", (Object)resultString);
        }
        catch (Exception e) {
            String message = String.format("Report v1 event to event-master failed, postBody:%s.", postBody);
            throw new PolarisException(ErrorCode.SERVER_USER_ERROR, message, (Throwable)e);
        }
    }

    class TsfEventV1Task
    implements Runnable {
        TsfEventV1Task() {
        }

        @Override
        public void run() {
            try {
                while (!TsfEventReporter.this.v1EventQueue.isEmpty()) {
                    ArrayList<TsfEventData> eventDataList = new ArrayList<TsfEventData>();
                    TsfGenericEvent genericEvent = new TsfGenericEvent();
                    TsfEventReporter.this.v1EventQueue.drainTo(eventDataList, TsfEventDataConstants.MAX_BATCH_SIZE);
                    genericEvent.setEventData(eventDataList);
                    genericEvent.setAppId(TsfEventReporter.this.tsfEventReporterConfig.getAppId());
                    genericEvent.setRegion(TsfEventReporter.this.tsfEventReporterConfig.getRegion());
                    TsfEventReporter.this.postV1Event(genericEvent);
                }
            }
            catch (Throwable e) {
                LOG.warn("Tsf v1 event reporter task fail.", e);
            }
        }
    }
}

