/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc.codec;

import com.google.protobuf.Message;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.registry.AbstractCacheHandler;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.pojo.ServiceRuleByProto;
import com.tencent.polaris.specification.api.v1.fault.tolerance.FaultDetectorProto;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class FaultDetectCacheHandler
extends AbstractCacheHandler {
    protected String getRevision(ResponseProto.DiscoverResponse discoverResponse) {
        FaultDetectorProto.FaultDetector faultDetector = discoverResponse.getFaultDetector();
        if (null == faultDetector) {
            return "";
        }
        return faultDetector.getRevision();
    }

    public ServiceEventKey.EventType getTargetEventType() {
        return ServiceEventKey.EventType.FAULT_DETECTING;
    }

    public RegistryCacheValue messageToCacheValue(RegistryCacheValue oldValue, Object newValue, boolean isCacheLoaded, FlowCache flowCache) {
        ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)newValue;
        FaultDetectorProto.FaultDetector faultDetector = discoverResponse.getFaultDetector();
        String revision = "";
        if (null != faultDetector) {
            revision = faultDetector.getRevision();
        }
        FaultDetectorProto.FaultDetector.Builder newFaultDetectorBuilder = FaultDetectorProto.FaultDetector.newBuilder().mergeFrom(faultDetector);
        List faultDetectRuleList = faultDetector.getRulesList();
        if (CollectionUtils.isNotEmpty((Collection)faultDetectRuleList)) {
            ArrayList<FaultDetectorProto.FaultDetectRule> newFaultDetectRuleList = new ArrayList<FaultDetectorProto.FaultDetectRule>();
            for (FaultDetectorProto.FaultDetectRule rule : faultDetectRuleList) {
                if (rule.hasTargetService() && rule.getTargetService().hasMethod()) {
                    FaultDetectorProto.FaultDetectRule.DestinationService.Builder newDestBuilder = FaultDetectorProto.FaultDetectRule.DestinationService.newBuilder().mergeFrom(rule.getTargetService());
                    newDestBuilder.setApi(ModelProto.API.newBuilder().setPath(rule.getTargetService().getMethod()).build());
                    FaultDetectorProto.FaultDetectRule.Builder newFaultDetectRuleBuilder = FaultDetectorProto.FaultDetectRule.newBuilder().mergeFrom(rule);
                    newFaultDetectRuleBuilder.setTargetService(newDestBuilder.build());
                    newFaultDetectRuleList.add(newFaultDetectRuleBuilder.build());
                    continue;
                }
                newFaultDetectRuleList.add(rule);
            }
            newFaultDetectRuleList.sort(Comparator.comparingInt(FaultDetectorProto.FaultDetectRule::getPriority));
            newFaultDetectorBuilder.clearRules();
            newFaultDetectorBuilder.addAllRules(newFaultDetectRuleList);
            faultDetector = newFaultDetectorBuilder.build();
        }
        return new ServiceRuleByProto((Message)faultDetector, revision, isCacheLoaded, this.getTargetEventType());
    }
}

