/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc.codec;

import com.google.protobuf.Message;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.cache.FlowCacheUtils;
import com.tencent.polaris.api.plugin.registry.AbstractCacheHandler;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.pojo.ServiceRuleByProto;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CircuitBreakCacheHandler
extends AbstractCacheHandler {
    public ServiceEventKey.EventType getTargetEventType() {
        return ServiceEventKey.EventType.CIRCUIT_BREAKING;
    }

    protected String getRevision(ResponseProto.DiscoverResponse discoverResponse) {
        CircuitBreakerProto.CircuitBreaker circuitBreaker = discoverResponse.getCircuitBreaker();
        if (null == circuitBreaker) {
            return "";
        }
        return circuitBreaker.getRevision().getValue();
    }

    public RegistryCacheValue messageToCacheValue(RegistryCacheValue oldValue, Object newValue, boolean isCacheLoaded, FlowCache flowCache) {
        CircuitBreakerProto.CircuitBreaker.Builder newCircuitBreakerBuilder;
        List circuitBreakerRuleList;
        ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)newValue;
        CircuitBreakerProto.CircuitBreaker circuitBreaker = discoverResponse.getCircuitBreaker();
        String revision = "";
        if (null != circuitBreaker) {
            revision = circuitBreaker.getRevision().getValue();
        }
        if (CollectionUtils.isNotEmpty((Collection)(circuitBreakerRuleList = (newCircuitBreakerBuilder = CircuitBreakerProto.CircuitBreaker.newBuilder().mergeFrom(circuitBreaker)).getRulesList()))) {
            ArrayList<CircuitBreakerProto.CircuitBreakerRule> newCircuitBreakerRuleList = new ArrayList<CircuitBreakerProto.CircuitBreakerRule>();
            boolean needUpdate = false;
            for (CircuitBreakerProto.CircuitBreakerRule rule : circuitBreakerRuleList) {
                ModelProto.MatchString matchString;
                if (CollectionUtils.isNotEmpty((Collection)rule.getErrorConditionsList()) && CollectionUtils.isNotEmpty((Collection)rule.getTriggerConditionList()) && CollectionUtils.isEmpty((Collection)rule.getBlockConfigsList())) {
                    needUpdate = true;
                    CircuitBreakerProto.CircuitBreakerRule.Builder ruleBuilder = CircuitBreakerProto.CircuitBreakerRule.newBuilder().mergeFrom(rule);
                    CircuitBreakerProto.BlockConfig.Builder blockConfigBuilder = CircuitBreakerProto.BlockConfig.newBuilder();
                    blockConfigBuilder.addAllErrorConditions((Iterable)rule.getErrorConditionsList());
                    blockConfigBuilder.addAllTriggerConditions((Iterable)rule.getTriggerConditionList());
                    ModelProto.API.Builder apiBuilder = ModelProto.API.newBuilder();
                    apiBuilder.setProtocol("*");
                    apiBuilder.setMethod("*");
                    matchString = rule.getRuleMatcher().getDestination().getMethod();
                    apiBuilder.setPath(matchString);
                    FlowCacheUtils.saveApiTrie((ModelProto.MatchString)matchString, (FlowCache)flowCache);
                    blockConfigBuilder.setApi(apiBuilder.build());
                    ruleBuilder.addBlockConfigs(blockConfigBuilder.build());
                    newCircuitBreakerRuleList.add(ruleBuilder.build());
                    continue;
                }
                List blockConfigList = rule.getBlockConfigsList();
                for (CircuitBreakerProto.BlockConfig blockConfig : blockConfigList) {
                    matchString = blockConfig.getApi().getPath();
                    FlowCacheUtils.saveApiTrie((ModelProto.MatchString)matchString, (FlowCache)flowCache);
                }
            }
            if (needUpdate) {
                newCircuitBreakerBuilder.clearRules();
                newCircuitBreakerBuilder.addAllRules(newCircuitBreakerRuleList);
                circuitBreaker = newCircuitBreakerBuilder.build();
            }
        }
        return new ServiceRuleByProto((Message)circuitBreaker, revision, isCacheLoaded, this.getTargetEventType());
    }
}

