/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.registry;

import com.tencent.cloud.common.metadata.StaticMetadataManager;
import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.cloud.polaris.context.PolarisSDKContextManager;
import com.tencent.cloud.polaris.discovery.PolarisDiscoveryHandler;
import com.tencent.cloud.polaris.registry.PolarisRegistration;
import com.tencent.cloud.polaris.util.OkHttpUtil;
import com.tencent.cloud.rpc.enhancement.stat.config.PolarisStatProperties;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.stat.ReporterMetaInfo;
import com.tencent.polaris.api.plugin.stat.StatReporter;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.rpc.InstanceDeregisterRequest;
import com.tencent.polaris.api.rpc.InstanceHeartbeatRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterResponse;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.factory.config.provider.ServiceConfigImpl;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.util.ReflectionUtils;

public class PolarisServiceRegistry
implements ServiceRegistry<PolarisRegistration>,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisServiceRegistry.class);
    private final PolarisDiscoveryProperties polarisDiscoveryProperties;
    private final PolarisSDKContextManager polarisSDKContextManager;
    private final PolarisDiscoveryHandler polarisDiscoveryHandler;
    private final StaticMetadataManager staticMetadataManager;
    private final PolarisStatProperties polarisStatProperties;
    private final ScheduledExecutorService heartbeatExecutor;

    public PolarisServiceRegistry(PolarisDiscoveryProperties polarisDiscoveryProperties, PolarisSDKContextManager polarisSDKContextManager, PolarisDiscoveryHandler polarisDiscoveryHandler, StaticMetadataManager staticMetadataManager, PolarisStatProperties polarisStatProperties) {
        this.polarisDiscoveryProperties = polarisDiscoveryProperties;
        this.polarisSDKContextManager = polarisSDKContextManager;
        this.polarisDiscoveryHandler = polarisDiscoveryHandler;
        this.staticMetadataManager = staticMetadataManager;
        this.heartbeatExecutor = StringUtils.isNotBlank((String)polarisDiscoveryProperties.getHealthCheckUrl()) ? Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("polaris-heartbeat")) : null;
        this.polarisStatProperties = polarisStatProperties;
    }

    public void register(PolarisRegistration registration) {
        if (StringUtils.isBlank((String)registration.getServiceId())) {
            LOGGER.warn("No service to register for polaris client...");
            return;
        }
        registration.customize();
        String serviceId = registration.getServiceId();
        InstanceRegisterRequest instanceRegisterRequest = new InstanceRegisterRequest();
        instanceRegisterRequest.setNamespace(this.polarisDiscoveryProperties.getNamespace());
        instanceRegisterRequest.setService(serviceId);
        instanceRegisterRequest.setHost(registration.getHost());
        instanceRegisterRequest.setPort(Integer.valueOf(registration.getPort()));
        instanceRegisterRequest.setWeight(Integer.valueOf(this.polarisDiscoveryProperties.getWeight()));
        instanceRegisterRequest.setToken(this.polarisDiscoveryProperties.getToken());
        instanceRegisterRequest.setRegion(this.staticMetadataManager.getRegion());
        instanceRegisterRequest.setZone(this.staticMetadataManager.getZone());
        instanceRegisterRequest.setCampus(this.staticMetadataManager.getCampus());
        instanceRegisterRequest.setTtl(this.polarisDiscoveryProperties.getHeartbeatInterval());
        instanceRegisterRequest.setMetadata(registration.getMetadata());
        instanceRegisterRequest.setProtocol(this.polarisDiscoveryProperties.getProtocol());
        instanceRegisterRequest.setVersion(this.polarisDiscoveryProperties.getVersion());
        instanceRegisterRequest.setInstanceId(this.polarisDiscoveryProperties.getInstanceId());
        try {
            InstanceRegisterResponse instanceRegisterResponse;
            ProviderAPI providerClient = this.polarisSDKContextManager.getProviderAPI();
            if (StringUtils.isBlank((String)this.polarisDiscoveryProperties.getHealthCheckUrl())) {
                instanceRegisterResponse = providerClient.registerInstance(instanceRegisterRequest);
            } else {
                instanceRegisterResponse = providerClient.register(instanceRegisterRequest);
                InstanceHeartbeatRequest heartbeatRequest = new InstanceHeartbeatRequest();
                BeanUtils.copyProperties((Object)instanceRegisterRequest, (Object)heartbeatRequest);
                this.heartbeat(heartbeatRequest);
            }
            registration.setInstanceId(instanceRegisterResponse.getInstanceId());
            LOGGER.info("polaris registry, {} {} {}:{} {} register finished", new Object[]{this.polarisDiscoveryProperties.getNamespace(), registration.getServiceId(), registration.getHost(), registration.getPort(), this.staticMetadataManager.getMergedStaticMetadata()});
            if (Objects.nonNull(this.polarisStatProperties) && this.polarisStatProperties.isEnabled()) {
                try {
                    StatReporter statReporter = (StatReporter)this.polarisSDKContextManager.getSDKContext().getPlugins().getPlugin(PluginTypes.STAT_REPORTER.getBaseType(), "prometheus");
                    if (Objects.nonNull(statReporter)) {
                        ReporterMetaInfo reporterMetaInfo = statReporter.metaInfo();
                        if (reporterMetaInfo.getPort() != null) {
                            LOGGER.info("Stat server started on port: " + reporterMetaInfo.getPort() + " (http)");
                        } else {
                            LOGGER.info("Stat server is set to type of Push gateway");
                        }
                    } else {
                        LOGGER.warn("Plugin StatReporter not found");
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Stat server started error, ", (Throwable)e);
                }
            }
            ServiceConfigImpl serviceConfig = (ServiceConfigImpl)this.polarisSDKContextManager.getSDKContext().getConfig().getProvider().getService();
            serviceConfig.setNamespace(this.polarisDiscoveryProperties.getNamespace());
            serviceConfig.setName(serviceId);
            PolarisSDKContextManager.isRegistered = true;
        }
        catch (Exception e) {
            LOGGER.error("polaris registry, {} register failed...{},", new Object[]{registration.getServiceId(), registration, e});
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(PolarisRegistration registration) {
        LOGGER.info("De-registering from Polaris Server now...");
        if (StringUtils.isEmpty((String)registration.getServiceId())) {
            LOGGER.warn("No dom to de-register for polaris client...");
            return;
        }
        InstanceDeregisterRequest deRegisterRequest = new InstanceDeregisterRequest();
        deRegisterRequest.setToken(this.polarisDiscoveryProperties.getToken());
        deRegisterRequest.setNamespace(this.polarisDiscoveryProperties.getNamespace());
        deRegisterRequest.setService(registration.getServiceId());
        deRegisterRequest.setHost(registration.getHost());
        deRegisterRequest.setPort(Integer.valueOf(registration.getPort()));
        try {
            ProviderAPI providerClient = this.polarisSDKContextManager.getProviderAPI();
            providerClient.deRegister(deRegisterRequest);
        }
        catch (Exception e) {
            LOGGER.error("ERR_POLARIS_DEREGISTER, de-register failed...{},", (Object)registration, (Object)e);
        }
        finally {
            if (null != this.heartbeatExecutor) {
                this.heartbeatExecutor.shutdown();
            }
            LOGGER.info("De-registration finished.");
            PolarisSDKContextManager.isRegistered = false;
        }
    }

    public void close() {
    }

    public void setStatus(PolarisRegistration registration, String status) {
    }

    public Object getStatus(PolarisRegistration registration) {
        String serviceName = registration.getServiceId();
        InstancesResponse instancesResponse = this.polarisDiscoveryHandler.getInstances(serviceName);
        Instance[] instances = instancesResponse.getInstances();
        if (null == instances) {
            return null;
        }
        for (Instance instance : instances) {
            if (!instance.getHost().equalsIgnoreCase(registration.getHost()) || instance.getPort() != registration.getPort()) continue;
            return instance.isHealthy() ? "UP" : "DOWN";
        }
        return null;
    }

    public void heartbeat(InstanceHeartbeatRequest heartbeatRequest) {
        this.heartbeatExecutor.scheduleWithFixedDelay(() -> {
            try {
                String healthCheckEndpoint = this.polarisDiscoveryProperties.getHealthCheckUrl();
                if (!healthCheckEndpoint.startsWith("/")) {
                    healthCheckEndpoint = "/" + healthCheckEndpoint;
                }
                String healthCheckUrl = String.format("http://%s:%s%s", heartbeatRequest.getHost(), heartbeatRequest.getPort(), healthCheckEndpoint);
                HashMap<String, String> headers = new HashMap<String, String>(1);
                headers.put("User-Agent", "polaris");
                if (!OkHttpUtil.get(healthCheckUrl, headers)) {
                    LOGGER.error("backend service health check failed. health check endpoint = {}", (Object)healthCheckEndpoint);
                    return;
                }
                this.polarisSDKContextManager.getProviderAPI().heartbeat(heartbeatRequest);
                LOGGER.trace("Polaris heartbeat is sent");
            }
            catch (PolarisException e) {
                LOGGER.error("polaris heartbeat error with code [{}]", (Object)e.getCode(), (Object)e);
            }
            catch (Exception e) {
                LOGGER.error("polaris heartbeat runtime error", (Throwable)e);
            }
        }, this.polarisDiscoveryProperties.getHeartbeatInterval().intValue(), this.polarisDiscoveryProperties.getHeartbeatInterval().intValue(), TimeUnit.SECONDS);
    }

    public void destroy() {
        if (this.heartbeatExecutor != null) {
            this.heartbeatExecutor.shutdown();
        }
    }
}

