/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.registry;

import com.tencent.cloud.common.metadata.StaticMetadataManager;
import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.cloud.polaris.extend.consul.ConsulContextProperties;
import com.tencent.cloud.polaris.extend.nacos.NacosContextProperties;
import com.tencent.cloud.polaris.registry.PolarisRegistrationCustomizer;
import com.tencent.polaris.client.api.SDKContext;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class PolarisRegistration
implements Registration {
    private static final String METADATA_KEY_IP = "internal-ip";
    private static final String METADATA_KEY_ADDRESS = "internal-address";
    private static final String GROUP_SERVER_ID_FORMAT = "%s__%s";
    private static final String NACOS_CLUSTER = "nacos.cluster";
    private final PolarisDiscoveryProperties polarisDiscoveryProperties;
    private final SDKContext polarisContext;
    private final StaticMetadataManager staticMetadataManager;
    private final String serviceId;
    private final String host;
    private final boolean isSecure;
    private final ServletWebServerApplicationContext servletWebServerApplicationContext;
    private final ReactiveWebServerApplicationContext reactiveWebServerApplicationContext;
    private final List<PolarisRegistrationCustomizer> customizers;
    private boolean registerEnabled = false;
    private Map<String, String> metadata;
    private int port;
    private String instanceId;

    public PolarisRegistration(PolarisDiscoveryProperties polarisDiscoveryProperties, @Nullable PolarisContextProperties polarisContextProperties, @Nullable ConsulContextProperties consulContextProperties, SDKContext context, StaticMetadataManager staticMetadataManager, @Nullable NacosContextProperties nacosContextProperties, @Nullable ServletWebServerApplicationContext servletWebServerApplicationContext, @Nullable ReactiveWebServerApplicationContext reactiveWebServerApplicationContext, @Nullable List<PolarisRegistrationCustomizer> registrationCustomizers) {
        String group;
        this.polarisDiscoveryProperties = polarisDiscoveryProperties;
        this.polarisContext = context;
        this.staticMetadataManager = staticMetadataManager;
        this.servletWebServerApplicationContext = servletWebServerApplicationContext;
        this.reactiveWebServerApplicationContext = reactiveWebServerApplicationContext;
        this.customizers = registrationCustomizers;
        this.serviceId = Objects.isNull(nacosContextProperties) ? polarisDiscoveryProperties.getService() : (StringUtils.isNotBlank((String)(group = nacosContextProperties.getGroup())) && !"DEFAULT_GROUP".equals(group) ? String.format(GROUP_SERVER_ID_FORMAT, group, polarisDiscoveryProperties.getService()) : polarisDiscoveryProperties.getService());
        this.host = this.polarisContext.getConfig().getGlobal().getAPI().getBindIP();
        if (polarisContextProperties != null) {
            this.port = polarisContextProperties.getLocalPort();
        }
        this.isSecure = StringUtils.equalsIgnoreCase((String)polarisDiscoveryProperties.getProtocol(), (String)"https");
        if (CollectionUtils.isEmpty(this.metadata)) {
            String clusterName;
            HashMap<String, String> instanceMetadata = new HashMap<String, String>();
            instanceMetadata.put(METADATA_KEY_IP, this.host);
            instanceMetadata.put(METADATA_KEY_ADDRESS, this.host + ":" + this.port);
            if (Objects.nonNull(nacosContextProperties) && StringUtils.isNotBlank((String)(clusterName = nacosContextProperties.getClusterName())) && !"DEFAULT".equals(clusterName)) {
                instanceMetadata.put(NACOS_CLUSTER, clusterName);
            }
            instanceMetadata.putAll(staticMetadataManager.getMergedStaticMetadata());
            this.metadata = instanceMetadata;
        }
        if (null != polarisDiscoveryProperties) {
            this.registerEnabled = polarisDiscoveryProperties.isRegisterEnabled();
        }
        if (null != consulContextProperties && consulContextProperties.isEnabled()) {
            this.registerEnabled |= consulContextProperties.isRegister();
        }
        if (null != nacosContextProperties && nacosContextProperties.isEnabled()) {
            this.registerEnabled |= nacosContextProperties.isRegisterEnabled();
        }
    }

    public static PolarisRegistration registration(PolarisDiscoveryProperties polarisDiscoveryProperties, @Nullable PolarisContextProperties polarisContextProperties, @Nullable ConsulContextProperties consulContextProperties, SDKContext context, StaticMetadataManager staticMetadataManager, @Nullable NacosContextProperties nacosContextProperties, @Nullable ServletWebServerApplicationContext servletWebServerApplicationContext, @Nullable ReactiveWebServerApplicationContext reactiveWebServerApplicationContext, @Nullable List<PolarisRegistrationCustomizer> registrationCustomizers) {
        PolarisRegistration polarisRegistration = new PolarisRegistration(polarisDiscoveryProperties, polarisContextProperties, consulContextProperties, context, staticMetadataManager, nacosContextProperties, servletWebServerApplicationContext, reactiveWebServerApplicationContext, registrationCustomizers);
        return polarisRegistration;
    }

    public void customize() {
        if (!CollectionUtils.isEmpty(this.customizers)) {
            for (PolarisRegistrationCustomizer customizer : this.customizers) {
                customizer.customize(this);
            }
        }
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        if (this.port <= 0) {
            if (this.servletWebServerApplicationContext != null) {
                this.port = this.servletWebServerApplicationContext.getWebServer().getPort();
            } else if (this.reactiveWebServerApplicationContext != null) {
                this.port = this.reactiveWebServerApplicationContext.getWebServer().getPort();
            } else {
                throw new RuntimeException("Unsupported web type.");
            }
        }
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public URI getUri() {
        return DefaultServiceInstance.getUri((ServiceInstance)this);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    protected void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public String toString() {
        return "PolarisRegistration{ polarisDiscoveryProperties=" + this.polarisDiscoveryProperties + ", polarisContext=" + this.polarisContext + ", staticMetadataManager=" + this.staticMetadataManager + ", metadata=" + this.metadata + ", host='" + this.host + '\'' + ", instanceId='" + this.instanceId + '\'' + '}';
    }
}

